/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.BaseImageSource;
import com.deltawalker.image.internal.Context;
import com.deltawalker.image.internal.IDataProvider;
import com.deltawalker.image.internal.Pyramid;
import com.deltawalker.image.internal.PyramidDefinition;
import java.awt.Dimension;
import java.io.IOException;
import javax.media.jai.PlanarImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PyramidImageSource
extends BaseImageSource {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.image.internal.PyramidImageSource");
    private static final boolean ADD_TILE_LISTENER = false;
    private final PyramidDefinition definition;
    private final Pyramid pyramid;

    PyramidImageSource(IDataProvider iDataProvider) throws IOException {
        super(iDataProvider);
        this.definition = PyramidDefinition.create(this.info);
        this.pyramid = new Pyramid(this.info);
        this.prepareFullPyramid();
    }

    @Override
    public PlanarImage bestImage(Context context) {
        return this.pyramid.bestImage(context);
    }

    PyramidDefinition definition() {
        return this.definition;
    }

    @Override
    public void dispose() {
        this.pyramid.disposeAll();
    }

    PlanarImage getImageAt(int n) {
        return this.pyramid.image(n);
    }

    private void prepareFullPyramid() throws IOException {
        Dimension dimension = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        int n = this.definition.layerCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.definition.subsample(n2);
            this.loader.setTileWidth(this.definition.tileWidth(n2));
            this.loader.setTileHeight(this.definition.tileHeight(n2));
            PlanarImage planarImage = this.read(n3);
            int n4 = planarImage.getWidth();
            int n5 = planarImage.getHeight();
            if (n4 >= dimension.width || n5 >= dimension.height) {
                LOG.warn("Invalid current image on layer=" + n2 + ": " + n4 + 'x' + n5 + " " + dimension.width + 'x' + dimension.height);
                break;
            }
            planarImage.setProperty("CanCancel", n2 != 0);
            dimension.setSize(n4, n5);
            this.pyramid.addImage(planarImage);
            ++n2;
        }
    }
}

