/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.ImageInfo;
import com.deltopia.MathUtil;
import com.deltopia.util.logging.ToString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PyramidDefinition {
    private static final int DEFAULT_TILE_SIZE = 512;
    private static final int MAX_LAYER_COUNT = 5;
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.image.internal.PyramidDefinition");
    private final int baseTileHeight;
    private final int baseTileWidth;
    private final int baseWidth;
    private final int height;
    private final int layerCount;
    private final int maxSubsample;

    private static final int calcSideForSubsample(int n, int n2) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("sideIn <= 0");
        }
        if (n2 <= 0 || n2 > n) {
            throw new IllegalArgumentException("subsample " + n2 + " out of range 1-" + n);
        }
        return (n + n2 - 1) / n2;
    }

    private static final int calcSubsample(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("layer");
        }
        return 1 << n;
    }

    public static final PyramidDefinition create(ImageInfo imageInfo) {
        return PyramidDefinition.create(imageInfo.width, imageInfo.height);
    }

    public static final PyramidDefinition create(int n, int n2) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Non-positive width");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Non-positive height");
        }
        int n3 = Math.max(n, n2);
        double d = (double)n3 / 512.0;
        int n4 = 1;
        if (d > 1.0 && (n4 = (int)Math.ceil(MathUtil.log2((double)d))) > 5) {
            n4 = 5;
        }
        int n5 = PyramidDefinition.calcSubsample(n4 - 1);
        int n6 = n <= 512 ? n : PyramidDefinition.calcSideForSubsample(n, n5);
        int n7 = n2 <= 512 ? n2 : PyramidDefinition.calcSideForSubsample(n2, n5);
        PyramidDefinition pyramidDefinition = new PyramidDefinition(n, n2, n4, n5, n6, n7);
        if (LOG.isInfoEnabled()) {
            LOG.info("Create pyramid definition: " + pyramidDefinition);
        }
        return pyramidDefinition;
    }

    private PyramidDefinition(int n, int n2, int n3, int n4, int n5, int n6) {
        this.baseWidth = n;
        this.height = n2;
        this.layerCount = n3;
        this.maxSubsample = n4;
        this.baseTileWidth = n5;
        this.baseTileHeight = n6;
    }

    public int baseHeight() {
        return this.height;
    }

    public int baseTileHeight() {
        return this.baseTileHeight;
    }

    public int baseTileWidth() {
        return this.baseTileWidth;
    }

    public int baseWidth() {
        return this.baseWidth;
    }

    public int height(int n) {
        int n2 = this.subsample(n);
        return PyramidDefinition.calcSideForSubsample(this.height, n2);
    }

    public int layerCount() {
        return this.layerCount;
    }

    public int maxSubsample() {
        return this.maxSubsample;
    }

    public int subsample(int n) {
        if (n < 0 || n >= this.layerCount) {
            throw new IllegalArgumentException("layer index: " + n);
        }
        return PyramidDefinition.calcSubsample(n);
    }

    public int tileHeight(int n) throws IllegalArgumentException {
        return Math.min(this.baseTileHeight, this.height(n));
    }

    public int tileWidth(int n) throws IllegalArgumentException {
        return Math.min(this.baseTileWidth, this.width(n));
    }

    public String toString() {
        return new ToString().append("width", this.baseWidth).append(", height", this.height).append(", layerCount", this.layerCount).append(", coeffSubsampleMax", this.maxSubsample).append(", baseTileWidth", this.baseTileWidth).append(", baseTileHeight", this.baseTileHeight).toString();
    }

    public int width(int n) throws IllegalArgumentException {
        int n2 = this.subsample(n);
        return PyramidDefinition.calcSideForSubsample(this.baseWidth, n2);
    }
}

