/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.ComparatorSize;
import com.deltawalker.image.internal.Context;
import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.Scale;
import com.deltawalker.image.internal.common.ImageOpUtil;
import com.deltopia.util.logging.ToString;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Pyramid {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.image.internal.Pyramid");
    private static final Comparator<PlanarImage> COMPARATOR = new ComparatorSize<PlanarImage>(9);
    private final boolean fineScale;
    private final List<PlanarImage> images;
    private final ImageInfo imgInfo;

    private static final String toString(PlanarImage planarImage) {
        return "@" + System.identityHashCode(planarImage) + " " + planarImage.getWidth() + 'x' + planarImage.getHeight();
    }

    Pyramid(ImageInfo imageInfo) throws NullPointerException {
        this(imageInfo, false);
    }

    Pyramid(ImageInfo imageInfo, boolean bl) throws NullPointerException {
        assert (imageInfo != null);
        this.imgInfo = imageInfo;
        this.fineScale = bl;
        this.images = new LinkedList<PlanarImage>();
    }

    void addImage(PlanarImage planarImage) throws IllegalArgumentException {
        if (planarImage.getWidth() > this.imgInfo.width || planarImage.getHeight() > this.imgInfo.height) {
            throw new IllegalArgumentException("Image too big: " + planarImage);
        }
        Scale scale = this.imgInfo.getRatio();
        Dimension dimension = scale.multiply(new Dimension(planarImage.getWidth(), planarImage.getHeight()));
        if (Math.abs(dimension.width - planarImage.getWidth()) > 1 || Math.abs(dimension.height - planarImage.getHeight()) > 1) {
            LOG.warn("Invalid ratio: " + scale + ", size=" + this.imgInfo.width + 'x' + this.imgInfo.height + " != " + planarImage + ", expected: " + dimension.width + 'x' + dimension.height);
        }
        this.addImageImpl(planarImage);
    }

    private synchronized void addImageImpl(PlanarImage planarImage) {
        int n = Collections.binarySearch(this.images, planarImage, COMPARATOR);
        assert (n < 0);
        int n2 = -(n + 1);
        this.images.add(n2, planarImage);
        if (LOG.isInfoEnabled()) {
            LOG.info("Add image on pos " + n2 + ": " + Pyramid.toString(planarImage));
        }
    }

    PlanarImage bestImage(Context context) throws IllegalStateException {
        return this.createImageForScale(context.getScale().getValueAsDouble(), null);
    }

    private PlanarImage createImageForScale(double d, RenderingHints renderingHints) {
        PlanarImage planarImage;
        assert (d > 0.0);
        PlanarImage planarImage2 = planarImage = this.nearestImage(d);
        if (this.fineScale) {
            Object object;
            double d2 = (double)planarImage.getWidth() / (d * (double)this.imgInfo.width);
            Interpolation interpolation = null;
            if (renderingHints != null && (object = renderingHints.get(JAI.KEY_INTERPOLATION)) instanceof Interpolation) {
                interpolation = (Interpolation)object;
            }
            planarImage2 = ImageOpUtil.scale(planarImage, d2, d2, interpolation);
            if (LOG.isInfoEnabled()) {
                LOG.info("Rescale pyramid image:\n\t" + Pyramid.toString(planarImage) + "\n\t" + Pyramid.toString(planarImage2));
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("Return image for scale=" + d + ": " + Pyramid.toString(planarImage2));
        }
        return planarImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAll() {
        PlanarImage[] planarImageArray;
        Pyramid pyramid = this;
        synchronized (pyramid) {
            planarImageArray = this.images.toArray(new PlanarImage[this.images.size()]);
            this.images.clear();
            if (LOG.isInfoEnabled()) {
                LOG.info("Dispose all images" + planarImageArray.length);
            }
        }
        int n = 0;
        while (n < planarImageArray.length) {
            PlanarImage planarImage = planarImageArray[n];
            try {
                ImageOpUtil.disposePlanarImageChain(planarImage);
            }
            catch (Exception exception) {
                LOG.error("Failed to dispose image from layer " + n, (Throwable)exception);
            }
            ++n;
        }
    }

    private synchronized int findNearestLayer(double d) {
        assert (!this.images.isEmpty());
        assert (d > 0.0);
        int n = (int)(d * (double)this.imgInfo.width);
        int n2 = 0;
        int n3 = this.images.size() - 1;
        while (n3 >= 0) {
            PlanarImage planarImage = this.images.get(n3);
            if (planarImage.getWidth() >= n) {
                n2 = n3;
                break;
            }
            --n3;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Find nearest layer from scale " + d + "=" + n2);
        }
        return n2;
    }

    synchronized PlanarImage image(int n) {
        return this.images.get(n);
    }

    public synchronized int layerCount() {
        return this.images.size();
    }

    private synchronized PlanarImage nearestImage(double d) throws IllegalArgumentException, IllegalStateException {
        int n = this.findNearestLayer(d);
        return this.image(n);
    }

    public String toString() {
        return new ToString().append("size", (Object)("" + this.imgInfo.width + 'x' + this.imgInfo.height)).append(", list", this.images).toString();
    }
}

