/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.ImageLog;

public enum ImageStoreFormat {
    BMP("bmp"),
    GIF("gif"),
    ICO("ico"),
    JPEG("jpeg", "jpg"),
    JPEG2000("jp2", "j2k", "jpeg 2000", "jpeg2000"),
    PICT("pct", "pict", "pic"),
    PNG("png"),
    PSD("psd"),
    TIFF("tiff", "tif"),
    PNM("ppm", "pgm", "pbm", "pnm"),
    UNKNOWN("unknown");

    private static final ImageStoreFormat[] IMAGE_FORMATS;
    private final String[] readers;

    static {
        ImageStoreFormat[] imageStoreFormatArray = ImageStoreFormat.values();
        IMAGE_FORMATS = new ImageStoreFormat[imageStoreFormatArray.length - 1];
        int n = 0;
        ImageStoreFormat[] imageStoreFormatArray2 = imageStoreFormatArray;
        int n2 = imageStoreFormatArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ImageStoreFormat imageStoreFormat = imageStoreFormatArray2[n3];
            if (imageStoreFormat != UNKNOWN) {
                ImageStoreFormat.IMAGE_FORMATS[n++] = imageStoreFormat;
            }
            ++n3;
        }
    }

    public static final ImageStoreFormat fromString(String string) throws NullPointerException {
        ImageStoreFormat[] imageStoreFormatArray;
        if (string == null) {
            throw new NullPointerException("format");
        }
        string = string.trim();
        ImageStoreFormat[] imageStoreFormatArray2 = imageStoreFormatArray = ImageStoreFormat.values();
        int n = imageStoreFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageStoreFormat imageStoreFormat = imageStoreFormatArray2[n2];
            if (imageStoreFormat.matches(string)) {
                return imageStoreFormat;
            }
            ++n2;
        }
        ImageLog.error("Unknown string for format: '" + string + '\'');
        return UNKNOWN;
    }

    public static final ImageStoreFormat[] getKnownList() {
        return (ImageStoreFormat[])IMAGE_FORMATS.clone();
    }

    private ImageStoreFormat(String ... stringArray) {
        this.readers = stringArray;
    }

    public String displayName() {
        return this != UNKNOWN ? this.readers[0] : null;
    }

    public String fileExtension() {
        return this.readers[0];
    }

    public String[] fileExtensions() {
        return (String[])this.readers.clone();
    }

    public boolean matches(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("strFormat");
        }
        String[] stringArray = this.readers;
        int n = this.readers.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string2.equalsIgnoreCase(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toStringPreferred() {
        return this != UNKNOWN ? this.readers[0] : null;
    }
}

