/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.BaseImageProvider;
import com.deltawalker.image.internal.Context;
import com.deltawalker.image.internal.DirectSingleImageSource;
import com.deltawalker.image.internal.IDataProvider;
import com.deltawalker.image.internal.IImageProvider;
import com.deltawalker.image.internal.IImageSource;
import com.deltawalker.image.internal.ITileList;
import com.deltawalker.image.internal.ITileListener;
import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.PyramidImageSource;
import com.deltawalker.image.internal.SingleImageSource;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.media.jai.PlanarImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageSourceFactory
implements IImageProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.image.internal.ImageSourceFactory");
    static final int TYPE_PYRAMID = 1;
    static final int TYPE_SINGLE = 2;
    static final int TYPE_SINGLE_DIRECT = 3;
    private static final int TYPE_DEF = 1;
    private final IImageProvider delegate;

    static IImageSource createSource(IDataProvider iDataProvider) throws IOException {
        try {
            return ImageSourceFactory.createSource(iDataProvider, 1);
        }
        catch (IIOException iIOException) {
            if ("Invalid icc profile: duplicate sequence numbers".equals(iIOException.getMessage())) {
                LOG.warn("Failed to create source " + iIOException.getMessage());
                return ImageSourceFactory.createSource(iDataProvider, 3);
            }
            throw iIOException;
        }
    }

    static IImageSource createSource(IDataProvider iDataProvider, int n) throws IOException {
        IImageSource iImageSource;
        switch (n) {
            case 1: {
                iImageSource = new PyramidImageSource(iDataProvider);
                break;
            }
            case 2: {
                iImageSource = new SingleImageSource(iDataProvider);
                break;
            }
            case 3: {
                iImageSource = new DirectSingleImageSource(iDataProvider);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return iImageSource;
    }

    public ImageSourceFactory(IDataProvider iDataProvider) throws IOException {
        IImageSource iImageSource = ImageSourceFactory.createSource(iDataProvider);
        this.delegate = new ImageProvider(iImageSource);
    }

    @Override
    public void addTileListener(ITileListener iTileListener) throws NullPointerException {
        this.delegate.addTileListener(iTileListener);
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }

    @Override
    public ImageInfo info() {
        return this.delegate.info();
    }

    @Override
    public void removeTileListener(ITileListener iTileListener) throws NullPointerException {
        this.delegate.removeTileListener(iTileListener);
    }

    @Override
    public ITileList requestTiles(ITileListener iTileListener, Context context) {
        return this.delegate.requestTiles(iTileListener, context);
    }

    public String toString() {
        return "delegate=" + this.delegate;
    }

    private static final class ImageProvider
    extends BaseImageProvider {
        private final IImageSource imageSource;

        private ImageProvider(IImageSource iImageSource) {
            super(iImageSource.info());
            this.imageSource = iImageSource;
        }

        @Override
        protected PlanarImage bestImage(Context context) {
            return this.imageSource.bestImage(context);
        }
    }
}

