/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.ImageStoreFormat;
import com.sun.imageio.plugins.gif.GIFImageReaderSpi;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.OperationRegistrySpi;
import javax.media.jai.TileCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ImageRegister {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.image.internal.ImageRegister");

    static {
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        ImageRegister.registerStreams(iIORegistry);
        ImageRegister.registerReaders(iIORegistry);
        ImageRegister.registerOperations();
        if (LOG.isInfoEnabled()) {
            ImageRegister.dumpSupportedFormats();
        }
        JAI jAI = JAI.getDefaultInstance();
        TileCache tileCache = jAI.getTileCache();
        tileCache.setMemoryCapacity(0x4000000L);
    }

    ImageRegister() {
    }

    private static void dumpSupportedFormats() {
        if (!LOG.isInfoEnabled()) {
            return;
        }
        String[] stringArray = ImageIO.getReaderFormatNames();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Supported read formats:\n");
        LinkedHashSet<ImageStoreFormat> linkedHashSet = new LinkedHashSet<ImageStoreFormat>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageStoreFormat imageStoreFormat;
            String string = stringArray2[n2];
            if (!(string.equalsIgnoreCase("raw") || string.equalsIgnoreCase("wbmp") || (imageStoreFormat = ImageStoreFormat.fromString(string)) == ImageStoreFormat.UNKNOWN || linkedHashSet.contains((Object)imageStoreFormat))) {
                linkedHashSet.add(imageStoreFormat);
                stringBuilder.append('\t').append((Object)imageStoreFormat).append('\n');
                Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
                while (iterator.hasNext()) {
                    ImageReader imageReader = iterator.next();
                    stringBuilder.append("\t\t").append(imageReader.getClass().getName()).append('\n');
                    imageReader.dispose();
                }
            }
            ++n2;
        }
        LOG.info(stringBuilder.toString());
    }

    public static final void initialize() {
    }

    private static final void registerOperations() {
        String[] stringArray = new String[]{"com.sun.media.jai.imageioimpl.ImageReadWriteSpi"};
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            try {
                Class<?> clazz = Class.forName(string);
                OperationRegistrySpi operationRegistrySpi = (OperationRegistrySpi)clazz.newInstance();
                operationRegistrySpi.updateRegistry(operationRegistry);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Registered operation spi: " + string);
                }
            }
            catch (Exception exception) {
                LOG.error("Cannot operation spi:" + string, (Throwable)exception);
            }
            ++n2;
        }
    }

    private static final void registerReaders(IIORegistry iIORegistry) {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"com.deltawalker.image.internal.loaders.gif.GIFImageReaderSpi", "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderSpi", "com.sun.media.imageioimpl.plugins.wbmp.WBMPImageReaderSpi", "com.sun.media.imageioimpl.plugins.bmp.BMPImageReaderSpi", "com.sun.media.imageioimpl.plugins.pnm.PNMImageReaderSpi", "com.sun.media.imageioimpl.plugins.raw.RawImageReaderSpi", "com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi", "com.twelvemonkeys.imageio.plugins.ico.ICOImageReaderSpi", "com.twelvemonkeys.imageio.plugins.pict.PICTImageReaderSpi", "com.twelvemonkeys.imageio.plugins.psd.PSDImageReaderSpi", "ch.randelshofer.media.jpeg.CMYKJPEGImageReaderSpi"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            try {
                Object object;
                Class<?> clazz = Class.forName(string);
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)clazz.newInstance();
                iIORegistry.registerServiceProvider(imageReaderSpi);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Registered reader: " + string);
                }
                if (string.equals("com.deltawalker.image.internal.loaders.gif.GIFImageReaderSpi")) {
                    object = iIORegistry.getServiceProviderByClass(GIFImageReaderSpi.class);
                    if (object != null) {
                        iIORegistry.deregisterServiceProvider(object);
                    }
                } else if (string.equals("ch.randelshofer.media.jpeg.CMYKJPEGImageReaderSpi")) {
                    object = iIORegistry.getServiceProviders(ImageReaderSpi.class, true);
                    ImageReaderSpi imageReaderSpi2 = null;
                    while (object.hasNext()) {
                        ImageReaderSpi imageReaderSpi3 = (ImageReaderSpi)object.next();
                        if (!imageReaderSpi3.getClass().getName().equals("com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi")) continue;
                        imageReaderSpi2 = imageReaderSpi3;
                    }
                    if (imageReaderSpi2 != null) {
                        iIORegistry.setOrdering(ImageReaderSpi.class, imageReaderSpi2, imageReaderSpi);
                    }
                }
            }
            catch (Exception exception) {
                LOG.error("Cannot register reader:" + string, (Throwable)exception);
            }
            ++n2;
        }
    }

    private static final void registerStreams(IIORegistry iIORegistry) {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"com.sun.media.imageioimpl.stream.ChannelImageOutputStreamSpi", "com.sun.media.imageioimpl.stream.ChannelImageInputStreamSpi"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            try {
                Class<?> clazz = Class.forName(string);
                IIOServiceProvider iIOServiceProvider = (IIOServiceProvider)clazz.newInstance();
                iIORegistry.registerServiceProvider(iIOServiceProvider);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Registered IO stream spi: " + string);
                }
            }
            catch (Exception exception) {
                LOG.error("Cannot IO stream spi:" + string, (Throwable)exception);
            }
            ++n2;
        }
    }

    private static final void registerWriters(IIORegistry iIORegistry) {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterSpi", "com.sun.media.imageioimpl.plugins.wbmp.WBMPImageWriterSpi", "com.sun.media.imageioimpl.plugins.bmp.BMPImageWriterSpi", "com.sun.media.imageioimpl.plugins.gif.GIFImageWriterSpi", "com.sun.media.imageioimpl.plugins.pnm.PNMImageWriterSpi", "com.sun.media.imageioimpl.plugins.raw.RawImageWriterSpi", "com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriterSpi"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            try {
                Class<?> clazz = Class.forName(string);
                ImageWriterSpi imageWriterSpi = (ImageWriterSpi)clazz.newInstance();
                iIORegistry.registerServiceProvider(imageWriterSpi);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Registered writer: " + string);
                }
            }
            catch (Exception exception) {
                LOG.error("Cannot register writer:" + string, (Throwable)exception);
            }
            ++n2;
        }
    }
}

