/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.ImageRegister;
import com.deltawalker.image.internal.ImageStoreFormat;
import com.deltawalker.image.internal.Msg;
import com.deltawalker.image.internal.Scale;
import com.deltawalker.image.internal.common.IOUtil;
import com.deltawalker.image.internal.common.ImageOpUtil;
import com.deltopia.StringUtil;
import com.deltopia.util.logging.ToString;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageLoader {
    private static final boolean ATTACH_DEV_LISTENER = false;
    private static final Logger LOG = LoggerFactory.getLogger(ImageLoader.class);
    private static final boolean READ_JAI = true;
    private static final boolean REAL_FRAMES_COUNT = false;
    private final Map<Class<? extends EventListener>, EventListener> listListener = new HashMap<Class<? extends EventListener>, EventListener>(3);
    private int tileHeight = 512;
    private int tileWidth = 512;

    static {
        ImageRegister.initialize();
    }

    private static final void closeSource(Object object) {
        if (object instanceof ImageInputStream) {
            IOUtil.closeSilent((ImageInputStream)object);
        } else if (object instanceof Closeable) {
            IOUtil.closeSilent((Closeable)object);
        }
    }

    public static String composeErrorMessage(String string) {
        return NLS.bind((String)Msg.ImageLoader_errCauseAction, (Object)(StringUtil.isEmpty((String)string) ? Msg.ImageLoader_errCannotRead : string), (Object)Msg.ImageLoader_errEmailSupport);
    }

    private static final int computeSubsampleFactor(int n, int n2) {
        int n3 = n2 > n ? 1 : (n2 == 1 ? n : (n - 1) / (n2 - 1));
        return n3 < 1 ? 1 : n3;
    }

    private static final Iterator<ImageReader> getImageReaders(ImageInputStream imageInputStream) throws IOException {
        assert (imageInputStream != null);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            throw new IIOException(ImageLoader.composeErrorMessage(Msg.ImageLoader_errNoReader));
        }
        return iterator;
    }

    private static final int subsampling(int n, int n2, int n3, int n4) {
        return Math.min(ImageLoader.computeSubsampleFactor(n, n3), ImageLoader.computeSubsampleFactor(n2, n4));
    }

    private static final String toString(Object object) {
        String string = object instanceof File ? "file: " + ((File)object).getPath() : (object instanceof byte[] ? "byte[]: " + ((byte[])object).length : (object instanceof InputStream ? "stream: " + object : String.valueOf(object)));
        return string;
    }

    public ImageLoader() {
    }

    public ImageLoader(int n, int n2) {
        this.tileWidth = n;
        this.tileHeight = n2;
    }

    public final int getTileHeight() {
        return this.tileHeight;
    }

    public final int getTileWidth() {
        return this.tileWidth;
    }

    private ImageInputStream obtainImageInputStream(Object object) throws IOException {
        ImageInputStream imageInputStream;
        if (object instanceof ImageInputStream) {
            imageInputStream = (ImageInputStream)object;
        } else {
            imageInputStream = ImageIO.createImageInputStream(object);
            if (imageInputStream == null) {
                throw new IIOException(ImageLoader.composeErrorMessage("Cannot read image from " + ImageLoader.toString(object)));
            }
        }
        return imageInputStream;
    }

    public final PlanarImage readFile(File file) throws NullPointerException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return this.readTiled(file);
    }

    public ImageInfo readImageDescriptor(File file) throws IOException {
        return this.readImageDescriptorImpl(file, true);
    }

    public ImageInfo readImageDescriptor(Object object) throws IOException {
        return this.readImageDescriptorImpl(object, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ImageInfo readImageDescriptorImpl(Object object, boolean bl) throws IOException {
        assert (object != null);
        ImageInputStream imageInputStream = this.obtainImageInputStream(object);
        try {
            Iterator<ImageReader> iterator = ImageLoader.getImageReaders(imageInputStream);
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                try {
                    ImageInfo imageInfo = this.readImageDescriptorWithReader(imageInputStream, imageReader);
                    return imageInfo;
                }
                catch (IOException iOException) {
                    try {
                        if (!iterator.hasNext()) {
                            throw iOException;
                        }
                        LOG.warn("Read failed with reader " + imageReader + ": " + iOException);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        throw new IllegalStateException();
                    }
                }
            }
        }
        finally {
            if (bl) {
                IOUtil.closeSilent(imageInputStream);
            }
        }
    }

    private ImageInfo readImageDescriptorWithReader(ImageInputStream imageInputStream, ImageReader imageReader) throws IOException {
        assert (imageInputStream != null);
        assert (imageReader != null);
        try {
            String string = imageReader.getFormatName();
            ImageStoreFormat imageStoreFormat = ImageStoreFormat.fromString(string);
            if (imageStoreFormat == ImageStoreFormat.UNKNOWN) {
                throw new IIOException("Unsupported format " + string);
            }
            imageReader.setInput(imageInputStream, true, true);
            int n = imageReader.getNumImages(false);
            int n2 = imageReader.getWidth(0);
            int n3 = imageReader.getHeight(0);
            if (n2 <= 0 || n3 <= 0) {
                throw new IIOException(ImageLoader.composeErrorMessage(NLS.bind((String)Msg.ImageLoader_errInvalidDimensions, (Object)n2, (Object)n3)));
            }
            Iterator<ImageTypeSpecifier> iterator = imageReader.getImageTypes(0);
            if (!iterator.hasNext()) {
                throw new IIOException(ImageLoader.composeErrorMessage(""));
            }
            ImageTypeSpecifier imageTypeSpecifier = iterator.next();
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug(new ToString().append("Stream Metadata", imageReader.getStreamMetadata()).toString());
                    LOG.debug(new ToString().append("Image 0 Metadata", imageReader.getImageMetadata(0)).toString());
                }
                catch (Exception exception) {
                    LOG.warn("Cannot read meta data because of " + exception);
                }
            }
            ImageInfo imageInfo = new ImageInfo(imageStoreFormat, n, n2, n3, imageTypeSpecifier.getColorModel(), imageTypeSpecifier.getSampleModel());
            return imageInfo;
        }
        catch (RuntimeException runtimeException) {
            throw new IIOException(NLS.bind((String)Msg.ImageLoader_errCauseAction, (Object)runtimeException.getLocalizedMessage(), (Object)Msg.ImageLoader_errEmailSupport), runtimeException);
        }
        finally {
            imageReader.dispose();
        }
    }

    private PlanarImage readImpl(Object object, int n, boolean bl) throws IllegalArgumentException, IOException {
        if (!(object instanceof File) && !(object instanceof InputStream)) {
            throw new IllegalArgumentException("Invalid source: " + object);
        }
        if (n < 1) {
            throw new IllegalArgumentException("Invalid subsample coefficient: " + n);
        }
        ImageInputStream imageInputStream = this.obtainImageInputStream(object);
        Iterator<ImageReader> iterator = ImageLoader.getImageReaders(imageInputStream);
        while (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            try {
                PlanarImage planarImage = this.readImplWithReader(imageInputStream, imageReader, n);
                planarImage = ImageOpUtil.convertToRGB(planarImage);
                planarImage.getWidth();
                if (LOG.isInfoEnabled()) {
                    LOG.info(new ToString().append("Create", (RenderedImage)planarImage).toString());
                }
                PlanarImage planarImage2 = planarImage;
                return planarImage2;
            }
            catch (IOException iOException) {
                if (!iterator.hasNext()) {
                    bl = true;
                    throw iOException;
                }
                LOG.warn("Read failed with reader " + imageReader + ": " + iOException);
            }
            finally {
                if (bl) {
                    ImageLoader.closeSource(object);
                }
            }
        }
        throw new IllegalStateException();
    }

    private PlanarImage readImplWithReader(ImageInputStream imageInputStream, ImageReader imageReader, int n) throws IOException {
        try {
            ImageReadParam imageReadParam = null;
            if (n > 1) {
                imageReadParam = new ImageReadParam();
                imageReadParam.setSourceSubsampling(n, n, 0, 0);
            }
            ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("ImageRead");
            parameterBlockJAI.setParameter("Input", imageInputStream);
            parameterBlockJAI.setParameter("ReadThumbnails", Boolean.FALSE);
            parameterBlockJAI.setParameter("VerifyInput", Boolean.TRUE);
            if (imageReadParam != null) {
                parameterBlockJAI.setParameter("ReadParam", imageReadParam);
            }
            parameterBlockJAI.setParameter("Reader", imageReader);
            ImageLayout imageLayout = new ImageLayout();
            imageLayout.setTileWidth(this.tileWidth);
            imageLayout.setTileHeight(this.tileHeight);
            imageLayout.setTileGridXOffset(0);
            imageLayout.setTileGridYOffset(0);
            RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
            RenderedOp renderedOp = JAI.create("ImageRead", parameterBlockJAI, renderingHints);
            ((PlanarImage)renderedOp).getWidth();
            if (((PlanarImage)renderedOp).getSampleModel() == null) {
                throw new IIOException(ImageLoader.composeErrorMessage(Msg.ImageReader_errNoSampleModel));
            }
            return renderedOp;
        }
        catch (RuntimeException runtimeException) {
            throw new IIOException("Failed to load", runtimeException);
        }
    }

    public final PlanarImage readThumbnail(File file, int n, int n2) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        if (imageInputStream == null) {
            throw new IIOException(ImageLoader.composeErrorMessage(""));
        }
        return this.readThumbnail(imageInputStream, n, n2);
    }

    private final PlanarImage readThumbnail(ImageInputStream imageInputStream, int n, int n2) throws IOException {
        assert (imageInputStream != null);
        long l = LOG.isInfoEnabled() ? System.currentTimeMillis() : 0L;
        try {
            Iterator<ImageReader> iterator = ImageLoader.getImageReaders(imageInputStream);
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                try {
                    Object object;
                    imageReader.setInput(imageInputStream, false, false);
                    ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                    int n3 = imageReader.getWidth(0);
                    int n4 = imageReader.getHeight(0);
                    Scale scale = Scale.create(n3, n4, n, n2);
                    if (!scale.isIdentity()) {
                        object = scale.multiply(new Dimension(n3, n4));
                        int n5 = ImageLoader.subsampling(n3, n4, ((Dimension)object).width, ((Dimension)object).height);
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Set sub-sampling: " + n5 + ", input=" + n3 + 'x' + n4 + ", output=" + n + 'x' + n2);
                        }
                        imageReadParam.setSourceSubsampling(n5, n5, 0, 0);
                    }
                    object = imageReader.read(0, imageReadParam);
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Load thumbnail: " + ((BufferedImage)object).getWidth() + 'x' + ((BufferedImage)object).getHeight() + ", output=" + n + 'x' + n2 + " for " + (System.currentTimeMillis() - l) + " ms");
                    }
                    PlanarImage planarImage = PlanarImage.wrapRenderedImage((RenderedImage)object);
                    imageReader.dispose();
                    return planarImage;
                }
                catch (IOException iOException) {
                    try {
                        if (!iterator.hasNext()) {
                            throw iOException;
                        }
                        LOG.warn("Read failed with reader " + imageReader + ": " + iOException);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        imageReader.dispose();
                    }
                }
            }
        }
        finally {
            imageInputStream.close();
        }
        throw new IllegalStateException();
    }

    private PlanarImage readTiled(File file) throws IOException {
        return this.readImpl(file, 1, false);
    }

    public PlanarImage readTiled(File file, int n) throws NullPointerException, IllegalArgumentException, IOException {
        return this.readImpl(file, n, false);
    }

    public PlanarImage readTiled(Object object, int n) throws IllegalArgumentException, IOException {
        return this.readImpl(object, n, false);
    }

    public final void setProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        if (iIOReadProgressListener == null) {
            this.listListener.remove(IIOReadProgressListener.class);
        } else {
            this.listListener.put(IIOReadProgressListener.class, iIOReadProgressListener);
        }
    }

    public final void setTileHeight(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Non-positive height");
        }
        this.tileHeight = n;
    }

    public final void setTileWidth(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Non-positive width");
        }
        this.tileWidth = n;
    }

    public final void setUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        if (iIOReadUpdateListener == null) {
            this.listListener.remove(IIOReadUpdateListener.class);
        } else {
            this.listListener.put(IIOReadUpdateListener.class, iIOReadUpdateListener);
        }
    }

    public final void setWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        if (iIOReadWarningListener == null) {
            this.listListener.remove(IIOReadWarningListener.class);
        } else {
            this.listListener.put(IIOReadWarningListener.class, iIOReadWarningListener);
        }
    }
}

