/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.ImageStoreFormat;
import com.deltawalker.image.internal.Scale;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;

public final class ImageInfo {
    public final ColorModel colorModel;
    public final int countImage;
    public final ImageStoreFormat format;
    public final int height;
    public final SampleModel sampleModel;
    public final int width;

    public ImageInfo(ImageStoreFormat imageStoreFormat, int n, int n2, int n3, ColorModel colorModel, SampleModel sampleModel) throws NullPointerException, IllegalArgumentException {
        if (imageStoreFormat == null) {
            throw new NullPointerException("format");
        }
        if (n <= 0 && n != -1) {
            throw new IllegalArgumentException("Invalid image count: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Non-positive width: " + n2);
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + n3);
        }
        if (colorModel == null) {
            throw new NullPointerException("colorModel");
        }
        if (sampleModel == null) {
            throw new NullPointerException("sampleModel");
        }
        this.format = imageStoreFormat;
        this.countImage = n;
        this.width = n2;
        this.height = n3;
        this.colorModel = colorModel;
        this.sampleModel = sampleModel;
    }

    public int getBiggerSide() {
        return Math.max(this.width, this.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public Scale getMinScale() {
        return Scale.create(this.getSmallerSide(), 1);
    }

    public Scale getRatio() {
        return Scale.create(this.width, this.height);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public int getSmallerSide() {
        return Math.min(this.width, this.height);
    }

    public String toString() {
        return (Object)((Object)this.format) + ", size=" + this.width + 'x' + this.height + ", countImage=" + this.countImage + "\n\t colorModel=" + this.colorModel + "\n\t sampleModel=" + this.sampleModel;
    }
}

