/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.Doc;
import com.deltawalker.image.internal.IDataProvider;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.resources.IPersistableResource;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltopia.io.CachedInputStreamSynchronizer;
import com.deltopia.io.ContentType;
import com.deltopia.io.StreamUtil;
import com.deltopia.io.TempFileBoss;
import com.deltopia.io.VfsUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageDoc
extends Doc
implements IDataProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ImageDoc.class);
    private static final boolean USE_CIS_SYNCER = "true".equalsIgnoreCase(System.getProperty("com.deltawalker.image.synchronizer", "true"));
    private CachedInputStreamSynchronizer cisSyncer = null;

    public ImageDoc(IDiffDoc iDiffDoc, Role role, IResource iResource, ContentType contentType) {
        super(iDiffDoc, role, iResource, contentType);
        if (LOG.isInfoEnabled()) {
            LOG.info("Create input '" + role + "' with resource: '" + iResource + '\'');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (USE_CIS_SYNCER) {
            ImageDoc imageDoc = this;
            synchronized (imageDoc) {
                if (this.cisSyncer != null) {
                    StreamUtil.closeSilently((Closeable)this.cisSyncer);
                }
            }
        }
        super.dispose();
    }

    @Override
    public boolean hasData() {
        return this.hasResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object obtainDataSource() throws IOException {
        File file;
        if (!this.hasData()) {
            throw new IOException("No resource set");
        }
        IResource iResource = this.resource();
        String string = iResource.getUri();
        if (!VfsUtil.hasVfsScheme((String)string)) {
            file = new File(string);
        } else if (iResource instanceof IPersistableResource) {
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            if (USE_CIS_SYNCER) {
                CachedInputStreamSynchronizer cachedInputStreamSynchronizer = null;
                ImageDoc imageDoc = this;
                synchronized (imageDoc) {
                    cachedInputStreamSynchronizer = this.cisSyncer;
                }
                if (cachedInputStreamSynchronizer == null) {
                    inputStream = iResource.file().createInputStream(true);
                    boolean bl = false;
                    try {
                        ImageDoc imageDoc2 = this;
                        synchronized (imageDoc2) {
                            if (this.cisSyncer == null) {
                                cachedInputStreamSynchronizer = this.cisSyncer = new CachedInputStreamSynchronizer(inputStream, TempFileBoss.getInstance(), -1);
                                if (LOG.isInfoEnabled()) {
                                    LOG.info("Create Cached input stream synchronizer");
                                }
                            } else {
                                bl = true;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        LOG.error("Failed to create cached stream from " + iResource, (Throwable)iOException);
                    }
                    if (bl) {
                        LOG.warn("2 threads created input stream");
                        StreamUtil.closeSilently((Closeable)inputStream);
                    }
                }
                if (cachedInputStreamSynchronizer != null) {
                    inputStream2 = cachedInputStreamSynchronizer.createStream();
                }
            }
            if (inputStream2 != null) {
                file = inputStream2;
            } else {
                if (inputStream == null) {
                    iResource.file().createInputStream(true);
                }
                file = inputStream;
            }
        } else {
            throw new IOException("Cannot acquire file content");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("+ Create source from resource '" + iResource + "': " + file);
        }
        return file;
    }
}

