/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.BaseImageProvider;
import com.deltawalker.image.internal.Context;
import com.deltawalker.image.internal.IDataProvider;
import com.deltawalker.image.internal.IImageProvider;
import com.deltawalker.image.internal.IImageSource;
import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.ImageSourceFactory;
import com.deltawalker.image.internal.common.ImageOpUtil;
import com.deltawalker.image.internal.common.operation.ImageDeltaKind;
import com.deltawalker.script.Role;
import com.deltopia.util.logging.ToString;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageDifferencer {
    private static final Logger LOG = LoggerFactory.getLogger(ImageDifferencer.class);
    private final Map<CacheId, CachedEntry> cache;
    private final Map<Role, IImageSource> imgSources = new EnumMap<Role, IImageSource>(Role.class);
    private final Set<ImageProvider> providers;

    public ImageDifferencer() {
        this.cache = new HashMap<CacheId, CachedEntry>(Role.count() * 2);
        this.providers = new HashSet<ImageProvider>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage bestImage(Role role, List<IImageSource> list, ImageDeltaKind imageDeltaKind, Context context) {
        Object object;
        PlanarImage planarImage = list.get(0).bestImage(context);
        assert (planarImage != null);
        if (imageDeltaKind == ImageDeltaKind.ALL || list.size() < 2) {
            return planarImage;
        }
        int n = 0;
        int n2 = 0;
        ArrayList<PlanarImage> arrayList = new ArrayList<PlanarImage>(list.size());
        for (IImageSource object22 : list) {
            object = object22.bestImage(context);
            n = Math.max(n, ((PlanarImage)object).getTileWidth());
            n2 = Math.max(n2, ((PlanarImage)object).getTileHeight());
            arrayList.add((PlanarImage)object);
        }
        assert (arrayList.size() > 1);
        CacheId cacheId = new CacheId(role, imageDeltaKind, context);
        Object object3 = this.cache;
        synchronized (object3) {
            object = this.cache.get(cacheId);
            if (object != null && ((CachedEntry)object).isSame(arrayList)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("- Use " + cacheId + " cached diff image: " + object);
                }
                return ((CachedEntry)object).imageDiff;
            }
        }
        object3 = new ImageLayout(0, 0, n, n2, null, null);
        object = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, object3);
        IImageSource iImageSource = list.get(1);
        PlanarImage planarImage2 = iImageSource.bestImage(context);
        assert (planarImage2 != null);
        PlanarImage planarImage3 = null;
        if (list.size() == 3) {
            IImageSource n3 = list.get(2);
            planarImage3 = n3.bestImage(context);
        }
        int n3 = context.getThreshold();
        PlanarImage planarImage4 = ImageOpUtil.compare(role, planarImage, planarImage2, planarImage3, imageDeltaKind, 0.0, n3, (RenderingHints)object);
        planarImage4.setProperty("CanCancel", planarImage.getProperty("CanCancel"));
        if (LOG.isInfoEnabled()) {
            LOG.info("+++ Create " + role + " image from " + (Object)((Object)imageDeltaKind) + " comparison: @" + System.identityHashCode(planarImage4) + " " + planarImage4);
        }
        Map<CacheId, CachedEntry> map = this.cache;
        synchronized (map) {
            CachedEntry cachedEntry = new CachedEntry(arrayList, planarImage4);
            CachedEntry cachedEntry2 = this.cache.put(cacheId, cachedEntry);
            if (LOG.isInfoEnabled()) {
                if (cachedEntry2 != null) {
                    LOG.info("! Replace " + cacheId + " cached diff image: " + cachedEntry2 + "-> " + cachedEntry);
                } else {
                    LOG.info("+ Cache " + cacheId + " image: " + cachedEntry);
                }
            }
        }
        return planarImage4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<ImageProvider> arrayList;
        ArrayList<IImageSource> arrayList2;
        ImageDifferencer object2 = this;
        synchronized (object2) {
            arrayList2 = new ArrayList<IImageSource>(this.imgSources.values());
        }
        for (IImageSource iImageSource : arrayList2) {
            if (iImageSource == null) continue;
            iImageSource.dispose();
        }
        Object object3 = this.providers;
        synchronized (object3) {
            arrayList = new ArrayList<ImageProvider>(this.providers);
            this.providers.clear();
        }
        for (Object object3 : arrayList) {
            ((BaseImageProvider)object3).dispose();
        }
    }

    public ImageInfo getDescriptor(Role role) {
        IImageSource iImageSource = this.source(role, false);
        return iImageSource != null ? iImageSource.info() : null;
    }

    PlanarImage image(Role role, ImageDeltaKind imageDeltaKind, Context context) throws NullPointerException {
        if (role == null) {
            throw new NullPointerException("role");
        }
        if (imageDeltaKind == null) {
            throw new NullPointerException("kind");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (imageDeltaKind == ImageDeltaKind.ALL) {
            IImageSource iImageSource = this.source(role, false);
            if (iImageSource == null) {
                return null;
            }
            return iImageSource.bestImage(context);
        }
        List<IImageSource> list = this.sourceImages(role);
        if (list == null) {
            return null;
        }
        PlanarImage planarImage = this.bestImage(role, list, imageDeltaKind, context);
        assert (planarImage != null);
        return planarImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isThreeWay() {
        ImageDifferencer imageDifferencer = this;
        synchronized (imageDifferencer) {
            return this.imgSources.containsKey(Role.TWO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImageProvider provider(Role role, ImageDeltaKind imageDeltaKind) {
        IImageSource iImageSource = this.source(role, false);
        ImageProvider imageProvider = null;
        Set<ImageProvider> set = this.providers;
        synchronized (set) {
            for (ImageProvider imageProvider2 : this.providers) {
                if (imageProvider2.role != role || imageProvider2.kind != imageDeltaKind) continue;
                imageProvider = imageProvider2;
                break;
            }
            if (iImageSource != null) {
                if (imageProvider == null) {
                    imageProvider = new ImageProvider(role, imageDeltaKind, iImageSource.info());
                    this.providers.add(imageProvider);
                }
            } else if (imageProvider != null) {
                this.providers.remove(imageProvider);
                imageProvider = null;
            }
        }
        return imageProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSource(Role role, IImageSource iImageSource) {
        IImageSource iImageSource2;
        ImageDifferencer imageDifferencer = this;
        synchronized (imageDifferencer) {
            iImageSource2 = this.imgSources.put(role, iImageSource);
        }
        if (iImageSource2 != null && iImageSource2 != iImageSource) {
            iImageSource2.dispose();
        }
    }

    public void setupSource(Role role, IDataProvider iDataProvider) throws IOException {
        assert (role != null);
        IImageSource iImageSource = null;
        try {
            if (iDataProvider != null && iDataProvider.hasData()) {
                iImageSource = ImageSourceFactory.createSource(iDataProvider);
            }
        }
        finally {
            this.setSource(role, iImageSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImageSource source(Role role, boolean bl) {
        assert (role != null);
        ImageDifferencer imageDifferencer = this;
        synchronized (imageDifferencer) {
            IImageSource iImageSource = this.imgSources.get(role);
            if (bl && iImageSource == null) {
                throw new IllegalStateException("Not set source for role: " + role);
            }
            return iImageSource;
        }
    }

    private List<IImageSource> sourceImages(Role role) {
        Role role2;
        Role role3;
        IImageSource iImageSource = this.source(role, false);
        if (iImageSource == null) {
            return null;
        }
        ArrayList<IImageSource> arrayList = new ArrayList<IImageSource>(3);
        if (role == Role.TWO) {
            role3 = Role.REF;
            role2 = Role.ONE;
        } else if (this.isThreeWay()) {
            role3 = Role.TWO;
            role2 = role == Role.REF ? Role.ONE : Role.REF;
        } else {
            role3 = role == Role.REF ? Role.ONE : Role.REF;
            role2 = null;
        }
        IImageSource iImageSource2 = this.source(role3, false);
        IImageSource iImageSource3 = role2 != null ? this.source(role2, false) : null;
        arrayList.add(iImageSource);
        if (iImageSource2 != null) {
            arrayList.add(iImageSource2);
        }
        if (iImageSource3 != null) {
            arrayList.add(iImageSource3);
        }
        return arrayList;
    }

    private static final class CacheId {
        private final Context context;
        private final ImageDeltaKind kind;
        private final Role role;

        private CacheId(Role role, ImageDeltaKind imageDeltaKind, Context context) {
            this.role = role;
            this.kind = imageDeltaKind;
            this.context = context;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CacheId cacheId = (CacheId)object;
            if (this.role != cacheId.role) {
                return false;
            }
            if (this.kind != cacheId.kind) {
                return false;
            }
            if (!this.context.getScale().equals(cacheId.context.getScale())) {
                return false;
            }
            return this.context.getThreshold() == cacheId.context.getThreshold();
        }

        public int hashCode() {
            int n = this.role.hashCode();
            n = 31 * n + this.kind.hashCode();
            n = 31 * n + this.context.getScale().hashCode();
            return n;
        }

        public String toString() {
            return "role=" + this.role + ", kind=" + (Object)((Object)this.kind) + ", threshold=" + this.context.getThreshold() + ", scale=" + this.context.getScale();
        }
    }

    private static final class CachedEntry {
        private static volatile int uidGlobal = 0;
        private final PlanarImage imageDiff;
        private final List<PlanarImage> images;
        private final int uid;

        CachedEntry(List<PlanarImage> list, PlanarImage planarImage) {
            this.images = list;
            this.imageDiff = planarImage;
            this.uid = uidGlobal++;
        }

        private boolean isSame(List<PlanarImage> list) {
            return this.images.equals(list);
        }

        public String toString() {
            ToString toString = new ToString();
            toString.append(this.uid).append(", images: ");
            int n = 0;
            while (n < this.images.size()) {
                PlanarImage planarImage = this.images.get(n);
                toString.append("@").append(System.identityHashCode(planarImage)).append(",");
                ++n;
            }
            return toString.toString();
        }
    }

    private final class ImageProvider
    extends BaseImageProvider {
        private final ImageDeltaKind kind;
        private final Role role;

        private ImageProvider(Role role, ImageDeltaKind imageDeltaKind, ImageInfo imageInfo) {
            super(imageInfo);
            this.role = role;
            this.kind = imageDeltaKind;
        }

        @Override
        protected PlanarImage bestImage(Context context) {
            return ImageDifferencer.this.image(this.role, this.kind, context);
        }

        public String toString() {
            return "Composite '" + this.role + "', kind=" + (Object)((Object)this.kind);
        }
    }
}

