/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.DiffDoc;
import com.deltawalker.DocType;
import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.image.internal.IImageProvider;
import com.deltawalker.image.internal.ImageDifferencer;
import com.deltawalker.image.internal.ImageDoc;
import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.common.operation.ImageDeltaKind;
import com.deltawalker.script.Role;
import java.io.IOException;
import java.util.Set;

public class ImageDiffDoc
extends DiffDoc {
    private final ImageDifferencer differencer = new ImageDifferencer();

    public ImageDiffDoc(DiffDoc.Builder builder) {
        super(builder);
        this.updateContent();
    }

    public void dispose() {
        try {
            this.differencer.dispose();
        }
        finally {
            super.dispose();
        }
    }

    public DocType docType() {
        return DocType.IMAGE;
    }

    public ImageInfo getImageDescriptor(Role role) {
        return this.differencer.getDescriptor(role);
    }

    public IImageProvider getProvider(Role role, ImageDeltaKind imageDeltaKind) {
        return this.differencer.provider(role, imageDeltaKind);
    }

    private void updateContent() {
        Set set = Relation.roles((boolean)this.isThreeWay());
        for (Role role : set) {
            ImageDoc imageDoc = (ImageDoc)this.doc(0, role);
            try {
                this.differencer.setupSource(role, imageDoc);
            }
            catch (IOException iOException) {
                this.updateUriInfo(role, UriInfo.Field.ERROR, iOException);
            }
        }
    }
}

