/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import ch.randelshofer.media.io.ImageInputStreamAdapter;
import com.deltawalker.image.internal.Context;
import com.deltawalker.image.internal.IDataProvider;
import com.deltawalker.image.internal.IImageSource;
import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.ImageStoreFormat;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.PlanarImage;

final class DirectSingleImageSource
implements IImageSource {
    private final PlanarImage image;
    private final ImageInfo info;

    private static final PlanarImage readImage(InputStream inputStream) throws IOException {
        try {
            JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
            BufferedImage bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
            PlanarImage planarImage = PlanarImage.wrapRenderedImage(bufferedImage);
            return planarImage;
        }
        finally {
            inputStream.close();
        }
    }

    public DirectSingleImageSource(IDataProvider iDataProvider) throws IOException {
        InputStream inputStream;
        Object object = iDataProvider.obtainDataSource();
        if (object instanceof File) {
            File file = (File)object;
            inputStream = new FileInputStream(file);
        } else if (object instanceof InputStream) {
            inputStream = (InputStream)object;
        } else if (object instanceof ImageInputStream) {
            inputStream = new ImageInputStreamAdapter((ImageInputStream)object);
        } else {
            throw new IllegalArgumentException("Unsupported data source " + object);
        }
        this.image = DirectSingleImageSource.readImage(inputStream);
        this.info = new ImageInfo(ImageStoreFormat.JPEG, 1, this.image.getWidth(), this.image.getHeight(), this.image.getColorModel(), this.image.getSampleModel());
    }

    @Override
    public PlanarImage bestImage(Context context) {
        return this.image;
    }

    @Override
    public void dispose() {
        this.image.dispose();
    }

    @Override
    public ImageInfo info() {
        return this.info;
    }
}

