/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltopia.MathUtil;
import java.awt.image.RenderedImage;
import java.util.Comparator;

public class ComparatorSize<T extends RenderedImage>
implements Comparator<T> {
    public static final int MASK_ALLOW_NULL = 16;
    public static final int MASK_DESCENDING = 8;
    public static final int MASK_HEIGHT = 2;
    public static final int MASK_PRIORITY_HEIGHT = 4;
    public static final int MASK_WIDTH = 1;
    private static final int MASK_ALL = 31;
    private final int mask;

    public ComparatorSize(int n) {
        if ((n & 0xFFFFFFE0) != 0) {
            throw new IllegalArgumentException("Invalid mask: " + n);
        }
        this.mask = n;
    }

    @Override
    public int compare(T t, T t2) {
        if (this.isSet(16)) {
            if (t == null) {
                return t2 != null ? 1 : 0;
            }
            if (t2 == null) {
                return -1;
            }
        } else {
            if (t == null) {
                throw new NullPointerException("image2");
            }
            if (t2 == null) {
                throw new NullPointerException("image2");
            }
        }
        int n = 0;
        if (this.isSet(4)) {
            if (this.isSet(2)) {
                n = MathUtil.compare((int)t.getHeight(), (int)t2.getHeight());
            }
            if (n == 0 && this.isSet(1)) {
                n = MathUtil.compare((int)t.getWidth(), (int)t2.getWidth());
            }
        } else {
            if (this.isSet(1)) {
                n = MathUtil.compare((int)t.getWidth(), (int)t2.getWidth());
            }
            if (n == 0 && this.isSet(2)) {
                n = MathUtil.compare((int)t.getHeight(), (int)t2.getHeight());
            }
        }
        if (n != 0 && this.isSet(8)) {
            n = -n;
        }
        return n;
    }

    private boolean isSet(int n) {
        return (this.mask & n) != 0;
    }
}

