/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.Context;
import com.deltawalker.image.internal.IDataProvider;
import com.deltawalker.image.internal.IImageSource;
import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.ImageLoader;
import com.deltopia.io.StreamUtil;
import com.deltopia.util.logging.ToString;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.IOException;
import javax.media.jai.PlanarImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseImageSource
implements IImageSource {
    private static final Logger LOG = LoggerFactory.getLogger(BaseImageSource.class);
    private final IDataProvider dataProvider;
    protected final ImageInfo info;
    protected final ImageLoader loader;

    protected BaseImageSource(IDataProvider iDataProvider) throws IOException {
        assert (iDataProvider != null);
        this.dataProvider = iDataProvider;
        this.loader = new ImageLoader();
        Object object = this.obtainDataSource();
        this.info = this.loader.readImageDescriptor(object);
        if (object instanceof Closeable) {
            StreamUtil.closeSilently((Closeable)((Closeable)object));
        }
    }

    @Override
    public abstract PlanarImage bestImage(Context var1);

    @Override
    public abstract void dispose();

    @Override
    public final ImageInfo info() {
        return this.info;
    }

    protected final Object obtainDataSource() throws IOException {
        return this.dataProvider.obtainDataSource();
    }

    protected final PlanarImage read() throws IOException {
        return this.read(1);
    }

    protected PlanarImage read(int n) throws IOException {
        PlanarImage planarImage = this.loader.readTiled(this.obtainDataSource(), n);
        if (LOG.isInfoEnabled()) {
            LOG.info(new ToString().append("Load image on subsample " + n, (RenderedImage)planarImage).toString());
        }
        return planarImage;
    }
}

