/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.Context;
import com.deltawalker.image.internal.EmptyTileList;
import com.deltawalker.image.internal.IImageProvider;
import com.deltawalker.image.internal.ITileList;
import com.deltawalker.image.internal.ITileListener;
import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.Scale;
import com.deltawalker.image.internal.TileList;
import com.deltawalker.image.internal.Tiler;
import com.deltopia.util.logging.ToString;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseImageProvider
implements IImageProvider {
    private static final boolean DEFERRED_REQUESTS = true;
    private static final Insets TILE_EXTEND = new Insets(1, 1, 1, 1);
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.image.internal.BaseImageProvider");
    protected final ImageInfo info;
    private final JaiAdapter jaiAdapter;
    private final Set<ITileListener> listeners;
    private final Set<Request> pendingRequests;

    public BaseImageProvider(ImageInfo imageInfo) {
        if (imageInfo == null) {
            throw new NullPointerException("info");
        }
        this.info = imageInfo;
        this.listeners = new LinkedHashSet<ITileListener>();
        this.pendingRequests = new LinkedHashSet<Request>();
        this.jaiAdapter = new JaiAdapter();
    }

    private final void addTileComputationListener(PlanarImage planarImage) {
        TileComputationListener[] tileComputationListenerArray = planarImage.getTileComputationListeners();
        if (tileComputationListenerArray != null) {
            TileComputationListener[] tileComputationListenerArray2 = tileComputationListenerArray;
            int n = tileComputationListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                TileComputationListener tileComputationListener = tileComputationListenerArray2[n2];
                if (tileComputationListener == this.jaiAdapter) {
                    return;
                }
                ++n2;
            }
        }
        planarImage.addTileComputationListener(this.jaiAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addTileListener(ITileListener iTileListener) throws NullPointerException {
        boolean bl;
        if (iTileListener == null) {
            throw new NullPointerException("listener");
        }
        Set<ITileListener> set = this.listeners;
        synchronized (set) {
            bl = this.listeners.add(iTileListener);
        }
        if (bl) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Add listener: " + iTileListener);
            }
        } else {
            LOG.warn("Cannot add listener: " + iTileListener);
        }
    }

    protected abstract PlanarImage bestImage(Context var1);

    @Override
    public void dispose() {
        this.jaiAdapter.cancelAllRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasTileListecner(ITileListener iTileListener) {
        Set<ITileListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.contains(iTileListener);
        }
    }

    @Override
    public final ImageInfo info() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyListeners(Request request, Collection<Tiler.TileIndex> collection) {
        if (collection == null || collection.size() <= 0) {
            throw new IllegalArgumentException("No tile list");
        }
        ITileListener iTileListener = null;
        Object object = this.listeners;
        synchronized (object) {
            if (this.listeners.size() <= 0) {
                return;
            }
            for (ITileListener iTileListener2 : this.listeners) {
                if (iTileListener2 != request.requestor) continue;
                iTileListener = iTileListener2;
                break;
            }
            if (iTileListener == null) {
                LOG.warn("Cannot find requestor " + request);
                return;
            }
        }
        object = new TileList(request.context, request.scaleBest2Context, request.rcReqImage, request.image, collection);
        if (LOG.isInfoEnabled()) {
            LOG.info("Notify " + iTileListener + " listener with: " + object);
        }
        iTileListener.processTilesComplete((ITileList)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeTileListener(ITileListener iTileListener) throws NullPointerException {
        if (iTileListener == null) {
            throw new NullPointerException("listener");
        }
        Set<ITileListener> set = this.listeners;
        synchronized (set) {
            boolean bl = this.listeners.remove(iTileListener);
            if (bl) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Remove listener: " + iTileListener);
                }
            } else if (this.listeners.size() > 0) {
                LOG.warn(new ToString().append("Cannot find listener for remove", (Object)iTileListener).append(", list", this.listeners).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITileList requestTiles(ITileListener iTileListener, Context context) throws NullPointerException {
        boolean bl;
        Object object;
        Object object2;
        assert (iTileListener != null) : "requestor is null";
        assert (context != null) : "context is null";
        if (!this.hasTileListecner(iTileListener)) {
            LOG.warn("Requestor which is not register as listener " + iTileListener);
        }
        Rectangle rectangle = context.getRoi();
        Point point = context.getOrigin();
        rectangle.translate(-point.x, -point.y);
        Scale scale = context.getScale();
        if (rectangle.isEmpty()) {
            LOG.warn("Requested empty rect : " + context);
            return new EmptyTileList(context);
        }
        PlanarImage planarImage = this.bestImage(context);
        boolean bl2 = false;
        if (context.canCancelRequests()) {
            object2 = planarImage.getProperty("CanCancel");
            boolean bl3 = bl2 = object2 instanceof Boolean && (Boolean)object2 != false;
        }
        if (bl2) {
            this.jaiAdapter.cancelNonImageRequests(planarImage);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(new ToString().appendID("Do NOT Cancel non-image request", (Object)planarImage).toString());
        }
        object2 = Scale.create(planarImage, this.info);
        Scale scale2 = scale.divide((Scale)object2);
        Rectangle rectangle2 = scale2.divide(rectangle);
        TileList.fixRectangle(rectangle2, scale2);
        if (!rectangle2.intersects(planarImage.getBounds())) {
            LOG.warn(new ToString().append("Rect out of image: ", (Object)context).append(", rectImage", rectangle2).append(",\n\t scales Full2Cur=", object2).append(" Cur2Context=", (Object)scale2).toString());
            return new EmptyTileList(context);
        }
        Tiler tiler = new Tiler(planarImage);
        Collection<Tiler.TileIndex> collection = tiler.tileToPaint(rectangle2, TILE_EXTEND);
        if (LOG.isInfoEnabled()) {
            LOG.info(new ToString().appendID("Request for image", (Object)planarImage).append(", context", (Object)context).append(", rectImage", rectangle2).append(",\n\t scales Full2Cur=" + object2).append(" Cur2Context=" + scale2).append(",\n\tindexes", collection).toString());
        }
        if (collection == null || collection.size() <= 0) {
            return new EmptyTileList(context);
        }
        TileCache tileCache = null;
        PlanarImage planarImage2 = planarImage;
        if (planarImage instanceof RenderedOp) {
            object = (RenderedOp)planarImage;
            planarImage2 = ((RenderedOp)planarImage).getRendering();
            tileCache = (TileCache)((RenderedOp)object).getRenderingHints().get(JAI.KEY_TILE_CACHE);
            if (tileCache == null) {
                LOG.warn("No tile cache for " + object);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            bl = false;
            if (planarImage instanceof RenderedImageAdapter) {
                object = (RenderedImageAdapter)planarImage;
                if (!(((RenderedImageAdapter)object).getWrappedImage() instanceof BufferedImage)) {
                    LOG.warn("Unknown image adapter " + planarImage);
                }
            } else {
                LOG.warn("Unknown image " + planarImage);
            }
        }
        object = new LinkedList();
        if (bl) {
            Object object3;
            assert (tileCache != null);
            LinkedList<Tiler.TileIndex> linkedList = new LinkedList<Tiler.TileIndex>();
            for (Tiler.TileIndex pointArray : collection) {
                object3 = tileCache.getTile(planarImage2, pointArray.x, pointArray.y);
                if (object3 != null) {
                    if (pointArray.isExtend) continue;
                    object.add(pointArray);
                    continue;
                }
                linkedList.add(pointArray);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(new ToString().append("Requested tiles: ").append("\n\tDeferred", linkedList).append("\n\tDirect", (Collection)object).toString());
            }
            if (linkedList.size() > 0) {
                this.addTileComputationListener(planarImage);
                Point[] pointArray = Tiler.listToArray(linkedList);
                TileRequest tileRequest = planarImage.queueTiles(pointArray);
                object3 = new Request(iTileListener, tileRequest, planarImage, context, scale2, rectangle2, linkedList);
                Set<Request> set = this.pendingRequests;
                synchronized (set) {
                    if (!this.pendingRequests.add((Request)object3)) {
                        LOG.warn("!!! Cannot add request: " + object3);
                    } else if (LOG.isInfoEnabled()) {
                        LOG.info("+++ Add request: " + object3);
                    }
                }
            }
        } else {
            LinkedList<Tiler.TileIndex> linkedList = new LinkedList<Tiler.TileIndex>();
            for (Tiler.TileIndex tileIndex : collection) {
                Raster raster;
                if (!tileIndex.isExtend) {
                    object.add(tileIndex);
                    continue;
                }
                if (tileCache == null || (raster = tileCache.getTile(planarImage2, tileIndex.x, tileIndex.y)) != null) continue;
                linkedList.add(tileIndex);
            }
            if (linkedList.size() > 0) {
                Point[] pointArray = Tiler.listToArray(linkedList);
                planarImage.queueTiles(pointArray);
            }
        }
        if (object.size() > 0) {
            return new TileList(context, scale2, rectangle2, planarImage, (Collection<Tiler.TileIndex>)object);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(new ToString().appendID("Return empty tile list for image", (Object)planarImage).toString());
        }
        return new EmptyTileList(context);
    }

    private final class JaiAdapter
    implements TileComputationListener {
        private JaiAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelAllRequests() {
            HashSet hashSet;
            Object object2 = BaseImageProvider.this.pendingRequests;
            synchronized (object2) {
                hashSet = new HashSet(BaseImageProvider.this.pendingRequests);
            }
            if (LOG.isDebugEnabled() && hashSet.size() > 0) {
                LOG.debug("Cancel all pending requests " + hashSet.size());
            }
            for (Object object2 : hashSet) {
                ((Request)object2).cancelRequest();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelNonImageRequests(PlanarImage planarImage) {
            HashSet hashSet;
            assert (planarImage != null) : "image is null";
            Object object2 = BaseImageProvider.this.pendingRequests;
            synchronized (object2) {
                hashSet = new HashSet(BaseImageProvider.this.pendingRequests);
            }
            for (Object object2 : hashSet) {
                if (((Request)object2).image == planarImage) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(new ToString().append("Cancel non-image request").appendID(", in=", (Object)planarImage).appendID(", cur=", (Object)((Request)object2).image).toString());
                }
                ((Request)object2).cancelRequest();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Request getRequest(TileRequest tileRequest) {
            Request request = null;
            Set set = BaseImageProvider.this.pendingRequests;
            synchronized (set) {
                for (Request request2 : BaseImageProvider.this.pendingRequests) {
                    if (!request2.tileRequest.equals(tileRequest)) continue;
                    request = request2;
                    break;
                }
            }
            return request;
        }

        @Override
        public void tileCancelled(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2) {
            this.tileFinished(tileRequestArray, n, n2, TileResult.CANCELED);
        }

        @Override
        public void tileComputationFailure(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2, Throwable throwable) {
            if (LOG.isInfoEnabled()) {
                LOG.warn("Tile failure " + n + "x" + n2 + ": " + throwable);
            }
            this.tileFinished(tileRequestArray, n, n2, TileResult.FAILED);
        }

        @Override
        public void tileComputed(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2, Raster raster) {
            List<Request> list;
            if (LOG.isInfoEnabled()) {
                LOG.info("+ Tile computed " + n + "x" + n2 + " from " + tileRequestArray.length + " requests");
            }
            if ((list = this.tileFinished(tileRequestArray, n, n2, TileResult.SUCCEEDED)).size() <= 0) {
                return;
            }
            RenderedOp renderedOp = (RenderedOp)list.get(0).image;
            PlanarImage planarImage2 = renderedOp.getRendering();
            TileCache tileCache = (TileCache)renderedOp.getRenderingHints().get(JAI.KEY_TILE_CACHE);
            Raster raster2 = tileCache.getTile(planarImage2, n, n2);
            if (raster2 == null) {
                LOG.error(new ToString().append("Tile raster is not cached " + n + 'x' + n2).appendID(" of image", (Object)planarImage).toString());
            }
            List<Tiler.TileIndex> list2 = Collections.singletonList(new Tiler.TileIndex(n, n2, false));
            for (Request request : list) {
                BaseImageProvider.this.notifyListeners(request, list2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Request> tileFinished(TileRequest[] tileRequestArray, int n, int n2, TileResult tileResult) {
            AbstractCollection abstractCollection;
            if (LOG.isInfoEnabled() && (abstractCollection = new LinkedHashSet<TileRequest>(Arrays.asList(tileRequestArray))).size() != tileRequestArray.length) {
                LOG.warn(new ToString().append("Doubled tile requests ", (Object[])tileRequestArray).toString());
            }
            abstractCollection = new ArrayList(tileRequestArray.length);
            Set set = BaseImageProvider.this.pendingRequests;
            synchronized (set) {
                TileRequest[] tileRequestArray2 = tileRequestArray;
                int n3 = tileRequestArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    TileRequest tileRequest = tileRequestArray2[n4];
                    Request request = this.getRequest(tileRequest);
                    if (request != null) {
                        Tiler.TileIndex tileIndex = request.finishIndex(n, n2, tileResult);
                        if (request.isFinished()) {
                            BaseImageProvider.this.pendingRequests.remove(request);
                            if (LOG.isInfoEnabled()) {
                                LOG.info("--- Remove request " + request);
                            }
                        }
                        if (tileIndex != null && !tileIndex.isExtend) {
                            abstractCollection.add(request);
                        }
                    } else if (LOG.isInfoEnabled()) {
                        LOG.warn(new ToString().appendID("Cannot find TileRequest on finish " + (Object)((Object)tileResult), (Object)tileRequest).append(", pending", (Collection)BaseImageProvider.this.pendingRequests).toString());
                    }
                    ++n4;
                }
            }
            return abstractCollection;
        }
    }

    private static final class Request {
        final ITileListener requestor;
        final Context context;
        private final PlanarImage image;
        private final Collection<Tiler.TileIndex> indexes;
        final Rectangle rcReqImage;
        private final Set<Tiler.TileIndex> remainingIndexes;
        final Scale scaleBest2Context;
        final TileRequest tileRequest;

        private Request(ITileListener iTileListener, TileRequest tileRequest, PlanarImage planarImage, Context context, Scale scale, Rectangle rectangle, Collection<Tiler.TileIndex> collection) {
            this.requestor = iTileListener;
            this.tileRequest = tileRequest;
            this.image = planarImage;
            this.context = context;
            this.scaleBest2Context = scale;
            this.rcReqImage = rectangle;
            this.indexes = collection;
            this.remainingIndexes = new LinkedHashSet<Tiler.TileIndex>(collection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelRequest() {
            Point[] pointArray;
            Request request = this;
            synchronized (request) {
                pointArray = Tiler.listToArray(this.remainingIndexes);
            }
            if (pointArray.length > 0) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(new ToString().append("Cancel request", (Object)this).toString());
                }
                this.tileRequest.cancelTiles(pointArray);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Request request = (Request)object;
            return this.tileRequest.equals(request.tileRequest);
        }

        synchronized Tiler.TileIndex finishIndex(int n, int n2, TileResult tileResult) {
            Tiler.TileIndex tileIndex = null;
            Iterator<Tiler.TileIndex> iterator = this.remainingIndexes.iterator();
            while (iterator.hasNext()) {
                Tiler.TileIndex tileIndex2 = iterator.next();
                if (!tileIndex2.equalsTo(n, n2)) continue;
                tileIndex = tileIndex2;
                iterator.remove();
                break;
            }
            if (tileIndex == null) {
                LOG.warn(new ToString().append("Not requested index: " + n + 'x' + n2).append(" of request", (Object)this).toString());
            } else if (LOG.isInfoEnabled()) {
                LOG.info(new ToString().append((Object)((Object)tileResult) + " index", (Object)tileIndex).append(" of request", (Object)this).toString());
            }
            return tileIndex;
        }

        public int hashCode() {
            return this.tileRequest.hashCode();
        }

        synchronized boolean isFinished() {
            return this.remainingIndexes.size() <= 0;
        }

        public String toString() {
            return new ToString().appendID(null, (Object)this).appendID(", image", (Object)this.image).appendID(", TR", (Object)this.tileRequest).append(", indexes", this.indexes).append(", remaining", this.remainingIndexes).append(", requestor", (Object)this.requestor).toString();
        }
    }

    private static enum TileResult {
        CANCELED,
        FAILED,
        SUCCEEDED;

    }
}

