/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.jpeg;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;

public class JFIFInputStream
extends FilterInputStream {
    private final HashSet<Integer> standaloneMarkers = new HashSet();
    private final HashSet<Integer> doubleSegMarkers = new HashSet();
    private Segment segment;
    private boolean markerFound;
    private int marker = -1;
    private long offset = 0L;
    private boolean isStuffed0xff = false;
    public static final int JUNK_MARKER = -1;
    public static final int SOI_MARKER = 65496;
    public static final int EOI_MARKER = 65497;
    public static final int TEM_MARKER = 65281;
    public static final int SOS_MARKER = 65498;
    public static final int APP1_MARKER = 65505;
    public static final int APP2_MARKER = 65506;
    public static final int JPG0_MARKER = 65520;
    public static final int JPG1_MARKER = 65521;
    public static final int JPG2_MARKER = 65522;
    public static final int JPG3_MARKER = 65523;
    public static final int JPG4_MARKER = 65524;
    public static final int JPG5_MARKER = 65525;
    public static final int JPG6_MARKER = 65526;
    public static final int JPG7_MARKER = 65527;
    public static final int JPG8_MARKER = 65528;
    public static final int JPG9_MARKER = 65529;
    public static final int JPGA_MARKER = 65530;
    public static final int JPGB_MARKER = 65531;
    public static final int JPGC_MARKER = 65532;
    public static final int JPGD_MARKER = 65533;
    public static final int SOF0_MARKER = 65472;
    public static final int SOF1_MARKER = 65473;
    public static final int SOF2_MARKER = 65474;
    public static final int SOF3_MARKER = 65475;
    public static final int SOF5_MARKER = 65477;
    public static final int SOF6_MARKER = 65478;
    public static final int SOF7_MARKER = 65479;
    public static final int SOF9_MARKER = 65481;
    public static final int SOFA_MARKER = 65482;
    public static final int SOFB_MARKER = 65483;
    public static final int SOFD_MARKER = 65485;
    public static final int SOFE_MARKER = 65486;
    public static final int SOFF_MARKER = 65487;
    public static final int RST0_MARKER = 65488;
    public static final int RST1_MARKER = 65489;
    public static final int RST2_MARKER = 65490;
    public static final int RST3_MARKER = 65491;
    public static final int RST4_MARKER = 65492;
    public static final int RST5_MARKER = 65493;
    public static final int RST6_MARKER = 65494;
    public static final int RST7_MARKER = 65495;

    public JFIFInputStream(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file)));
    }

    public JFIFInputStream(InputStream inputStream) {
        super(inputStream);
        int n = 65488;
        while (n <= 65495) {
            this.standaloneMarkers.add(n);
            ++n;
        }
        this.standaloneMarkers.add(65496);
        this.standaloneMarkers.add(65497);
        this.standaloneMarkers.add(65281);
        this.standaloneMarkers.add(65520);
        this.standaloneMarkers.add(65521);
        this.standaloneMarkers.add(65522);
        this.standaloneMarkers.add(65523);
        this.standaloneMarkers.add(65524);
        this.standaloneMarkers.add(65525);
        this.standaloneMarkers.add(65526);
        this.standaloneMarkers.add(65527);
        this.standaloneMarkers.add(65528);
        this.standaloneMarkers.add(65529);
        this.standaloneMarkers.add(65530);
        this.standaloneMarkers.add(65531);
        this.standaloneMarkers.add(65532);
        this.standaloneMarkers.add(65533);
        this.standaloneMarkers.add(65535);
        this.doubleSegMarkers.add(65498);
        this.segment = new Segment(-1, 0L, -1);
    }

    public Segment getSegment() throws IOException {
        return this.segment;
    }

    /*
     * Unable to fully structure code
     */
    public Segment getNextSegment() throws IOException {
        if (this.segment.isEntropyCoded()) ** GOTO lbl32
        this.markerFound = false;
        do {
            if ((var1_1 = this.in.skip((long)this.segment.length - this.offset + this.segment.offset)) == -1L) {
                this.segment = new Segment(0, this.offset, -1);
                return null;
            }
            this.offset += var1_1;
        } while (this.offset < (long)this.segment.length + this.segment.offset);
        if (!this.doubleSegMarkers.contains(this.segment.marker)) ** GOTO lbl32
        this.segment = new Segment(0, this.offset, -1);
        return this.segment;
lbl-1000:
        // 2 sources

        {
            if (this.isStuffed0xff) {
                var1_2 = 255;
                this.isStuffed0xff = false;
            } else {
                var1_2 = this.read0();
            }
            if (var1_2 == -1) {
                return null;
            }
            if (var1_2 != 255) continue;
            this.markerFound = true;
            var1_2 = this.read0();
            if (var1_2 == -1) {
                return null;
            }
            if (var1_2 == 0) {
                this.markerFound = false;
            } else if (var1_2 == 255) {
                this.isStuffed0xff = true;
                this.markerFound = false;
            } else {
                this.marker = 65280 | var1_2;
            }
lbl32:
            // 5 sources

            if (this.markerFound) break;
            ** while (true)
        }
        this.markerFound = false;
        if (this.standaloneMarkers.contains(this.marker)) {
            this.segment = new Segment(65280 | this.marker, this.offset, -1);
        } else {
            var1_3 = this.read0() << 8 | this.read0();
            if (var1_3 < 2 || var1_3 >= 65535) {
                throw new IOException("JFIFInputStream found illegal segment length " + var1_3 + " after marker " + Integer.toHexString(this.marker) + " at offset " + this.offset + ".");
            }
            this.segment = new Segment(65280 | this.marker, this.offset, var1_3 - 2);
        }
        return this.segment;
    }

    public long getStreamPosition() {
        return this.offset;
    }

    private int read0() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            ++this.offset;
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        int n;
        if (this.markerFound) {
            return -1;
        }
        if (this.isStuffed0xff) {
            this.isStuffed0xff = false;
            n = 255;
        } else {
            n = this.read0();
        }
        if (this.segment.isEntropyCoded() && n == 255) {
            n = this.read0();
            if (n == 0) {
                return 255;
            }
            if (n == 255) {
                this.isStuffed0xff = true;
                return 255;
            }
            this.markerFound = true;
            this.marker = 0xFF00 | n;
            return -1;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.markerFound) {
            return -1;
        }
        int n3 = 0;
        if (this.segment.isEntropyCoded()) {
            while (n3 < n2) {
                int n4 = this.read();
                if (n4 == -1) {
                    if (n3 == 0) {
                        return -1;
                    }
                    break;
                }
                byArray[n + n3] = (byte)n4;
                ++n3;
            }
        } else {
            long l = (long)this.segment.length - this.offset + this.segment.offset;
            if (l <= 0L) {
                return -1;
            }
            if (l < (long)n2) {
                n2 = (int)l;
            }
            if ((n3 = this.in.read(byArray, n, n2)) != -1) {
                this.offset += (long)n3;
            }
        }
        return n3;
    }

    public final void skipFully(long l) throws IOException {
        long l2 = 0L;
        long l3 = 0L;
        while (l2 < l && (l3 = (long)((int)this.in.skip(l - l2))) > 0L) {
            l2 += l3;
        }
        if (l2 < l) {
            throw new EOFException();
        }
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.markerFound) {
            return -1L;
        }
        long l2 = 0L;
        if (this.segment.isEntropyCoded()) {
            while (l2 < l) {
                int n = this.read();
                if (n != -1) {
                    ++l2;
                    continue;
                }
                break;
            }
        } else {
            long l3 = (long)this.segment.length - this.offset + this.segment.offset;
            if (l3 < l) {
                l = (int)l3;
            }
            if ((l2 = this.in.skip(l)) != -1L) {
                this.offset += l2;
            }
        }
        return l2;
    }

    @Override
    public synchronized void mark(int n) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public static class Segment {
        public final int marker;
        public final long offset;
        public final int length;

        public Segment(int n, long l, int n2) {
            this.marker = n;
            this.offset = l;
            this.length = n2;
        }

        public boolean isEntropyCoded() {
            return this.length == -1;
        }

        public String toString() {
            return "Segment marker=0x" + Integer.toHexString(this.marker) + " offset=" + this.offset + "=0x" + Long.toHexString(this.offset);
        }
    }
}

