/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.jpeg;

import ch.randelshofer.media.io.ByteArrayImageInputStream;
import ch.randelshofer.media.io.ImageInputStreamAdapter;
import ch.randelshofer.media.jpeg.JFIFInputStream;
import com.deltawalker.image.internal.common.ColorSpaceUtil;
import com.deltopia.util.logging.ToString;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMYKJPEGImageReader
extends ImageReader {
    private static final Logger LOG = LoggerFactory.getLogger((String)"ch.randelshofer.media.jpeg.CMYKJPEGImageReader");
    private static final boolean MEASURE = LOG.isInfoEnabled();
    private static final boolean USE_MANUAL_RGBA_RGB_CONVERSION = true;
    private static final ColorModel RGB_COMP = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
    private static final ColorModel RGBA_COMP = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
    private static final String TYPE_SPEC_RGB_INTERLEAVED = "RGBInterleaved";
    private static final Map<String, ImageTypeSpecifier> specifiers = new LinkedHashMap<String, ImageTypeSpecifier>(2);
    private boolean isYCCKInversed = true;
    private int numberOfComponentsInFrame;
    private ICC_Profile profile;
    private int app14AdobeColorTransform;
    private final AtomicBoolean isHeaderRead = new AtomicBoolean(false);
    private ImageInputStream iis;
    private ImageReader nativeReader;
    private Map<Integer, ImageTypeSpecifier> specifiersPerImage;
    private static final int SCALEBITS = 16;
    private static final int MAXJSAMPLE = 255;
    private static final int CENTERJSAMPLE = 128;
    private static final int ONE_HALF = 32768;
    private static final int[] Cr_r_tab;
    private static final int[] Cb_b_tab;
    private static final int[] Cr_g_tab;
    private static final int[] Cb_g_tab;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        specifiers.put(TYPE_SPEC_RGB_INTERLEAVED, ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1000), nArray, 0, false, false));
        Cr_r_tab = new int[256];
        Cb_b_tab = new int[256];
        Cr_g_tab = new int[256];
        Cb_g_tab = new int[256];
    }

    public CMYKJPEGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (object == null) {
            this.iis = null;
            return;
        }
        Object object2 = this.getInput();
        if (object2 instanceof byte[]) {
            this.iis = new ByteArrayImageInputStream((byte[])object2);
        } else if (object2 instanceof ImageInputStream) {
            this.iis = (ImageInputStream)object2;
        } else if (object2 instanceof InputStream) {
            this.iis = new MemoryCacheImageInputStream((InputStream)object2);
        } else {
            throw new IllegalArgumentException("Can't handle input of type " + object2);
        }
        this.specifiersPerImage = new LinkedHashMap<Integer, ImageTypeSpecifier>(1);
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        this.readHeader();
        return this.nativeReader.getNumImages(bl);
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.readHeader();
        return this.nativeReader.getWidth(n);
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.readHeader();
        return this.nativeReader.getHeight(n);
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        Object object;
        this.readHeader();
        int n2 = this.nativeReader.getWidth(n);
        int n3 = this.nativeReader.getHeight(n);
        ImageTypeSpecifier imageTypeSpecifier = this.specifiersPerImage.get(n);
        if (imageTypeSpecifier == null) {
            object = specifiers.get(TYPE_SPEC_RGB_INTERLEAVED);
            imageTypeSpecifier = new ImageTypeSpecifier(((ImageTypeSpecifier)object).getColorModel(), ((ImageTypeSpecifier)object).getSampleModel(n2, n3));
            this.specifiersPerImage.put(n, imageTypeSpecifier);
        }
        object = new LinkedList();
        ((LinkedList)object).add(imageTypeSpecifier);
        return ((AbstractSequentialList)object).iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return this.nativeReader.getStreamMetadata();
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        return this.nativeReader.getImageMetadata(n);
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        if (n > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.readHeader();
        BufferedImage bufferedImage = this.readData(n, imageReadParam);
        return bufferedImage;
    }

    private void readHeader() throws IOException {
        if (this.isHeaderRead.getAndSet(true)) {
            return;
        }
        if (this.iis == null) {
            throw new IOException("No input set");
        }
        this.iis.seek(0L);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.numberOfComponentsInFrame = 0;
        this.app14AdobeColorTransform = -1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JFIFInputStream jFIFInputStream = new JFIFInputStream(new ImageInputStreamAdapter(this.iis));
        JFIFInputStream.Segment segment = jFIFInputStream.getNextSegment();
        while (segment != null) {
            DataInputStream dataInputStream;
            if (65472 <= segment.marker && segment.marker <= 65475 || 65477 <= segment.marker && segment.marker <= 65479 || 65481 <= segment.marker && segment.marker <= 65483 || 65485 <= segment.marker && segment.marker <= 65487) {
                dataInputStream = new DataInputStream(jFIFInputStream);
                n = dataInputStream.readUnsignedByte();
                n2 = dataInputStream.readUnsignedShort();
                n3 = dataInputStream.readUnsignedShort();
                this.numberOfComponentsInFrame = dataInputStream.readUnsignedByte();
                break;
            }
            if (segment.marker == 65506) {
                if (segment.length >= 26 && (dataInputStream = new DataInputStream(jFIFInputStream)).readLong() == 5279137264856878918L && dataInputStream.readInt() == 1229735168) {
                    dataInputStream.skipBytes(2);
                    byte[] byArray = new byte[512];
                    int n4 = dataInputStream.read(byArray);
                    while (n4 != -1) {
                        byteArrayOutputStream.write(byArray, 0, n4);
                        n4 = dataInputStream.read(byArray);
                    }
                }
            } else if (segment.marker == 65518 && (segment.length >= 12 || segment.length <= 64) && (long)(dataInputStream = new DataInputStream(jFIFInputStream)).readInt() == 1097101154L && dataInputStream.readUnsignedShort() == 25856) {
                dataInputStream.readUnsignedByte();
                dataInputStream.readUnsignedShort();
                dataInputStream.readUnsignedShort();
                this.app14AdobeColorTransform = dataInputStream.readUnsignedByte();
            }
            segment = jFIFInputStream.getNextSegment();
        }
        if (this.app14AdobeColorTransform < 0) {
            LOG.warn("Cannot find app14AdobeColorTransform segment for input " + this.getInput());
            this.app14AdobeColorTransform = 0;
        }
        this.profile = null;
        if (byteArrayOutputStream.size() > 0) {
            try {
                this.profile = ICC_Profile.getInstance(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            }
            catch (Throwable throwable) {
                LOG.warn("Failed to load profile", throwable);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Read header: componentsInFrame=" + this.numberOfComponentsInFrame + ", app14=" + this.app14AdobeColorTransform + ", precision=" + n + ", lines=" + n2 + ", samplesPerLine=" + n3 + ", profile: " + this.profile);
        }
        if (this.app14AdobeColorTransform == 1) {
            throw new IOException("YCbCr not supported");
        }
        this.iis.seek(0L);
        this.nativeReader = CMYKJPEGImageReader.createNativeJPEGReader();
        this.nativeReader.setInput(this.iis);
    }

    private BufferedImage readData(int n, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = null;
        if (this.numberOfComponentsInFrame != 4) {
            bufferedImage = this.readImageFromYUVorGray(n, imageReadParam);
        } else if (this.numberOfComponentsInFrame == 4) {
            long l;
            if (1 == this.app14AdobeColorTransform) {
                throw new IOException("YCbCr not supported");
            }
            ColorSpace colorSpace = this.profile == null ? ColorSpaceUtil.getCMYKColorSpace() : new ICC_ColorSpace(this.profile);
            long l2 = MEASURE ? System.nanoTime() : 0L;
            Raster raster = this.nativeReader.readRaster(n, imageReadParam);
            if (MEASURE) {
                l = System.nanoTime() - l2;
                LOG.info(String.format("Read for %.3f ms", Float.valueOf((float)l / 1000000.0f)));
            }
            l = MEASURE ? System.nanoTime() : 0L;
            switch (this.app14AdobeColorTransform) {
                default: {
                    bufferedImage = this.createRGBAImageFromRGBA(n, raster, colorSpace);
                    break;
                }
                case 1: {
                    assert (false);
                    break;
                }
                case 2: {
                    bufferedImage = this.isYCCKInversed ? this.createRGBImageFromInvertedYCCK(n, raster, colorSpace) : this.createRGBImageFromYCCK(n, raster, colorSpace);
                }
            }
            if (MEASURE) {
                long l3 = System.nanoTime() - l;
                LOG.info(String.format("Convert for %.3f ms", Float.valueOf((float)l3 / 1000000.0f)));
            }
        }
        return bufferedImage;
    }

    private static final ImageReader createNativeJPEGReader() throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("jpeg");
        while (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            if (imageReader instanceof CMYKJPEGImageReader || !imageReader.canReadRaster()) continue;
            return imageReader;
        }
        throw new IOException("No internal JPEG loader");
    }

    private BufferedImage createRGBImageFromInvertedYCCK(int n, Raster raster, ColorSpace colorSpace) throws IOException {
        raster = this.convertInvertedYCCKToCMYK(raster);
        BufferedImage bufferedImage = this.createRGBImageFromCMYK(n, raster, colorSpace);
        return bufferedImage;
    }

    private BufferedImage createRGBImageFromYCCK(int n, Raster raster, ColorSpace colorSpace) throws IOException {
        BufferedImage bufferedImage;
        if (colorSpace != null) {
            raster = CMYKJPEGImageReader.convertYCCKtoCMYK(raster);
            bufferedImage = this.createRGBImageFromCMYK(n, raster, colorSpace);
        } else {
            int n2 = raster.getWidth();
            int n3 = raster.getHeight();
            int[] nArray = new int[n2 * n3];
            int[] nArray2 = raster.getSamples(0, 0, n2, n3, 0, (int[])null);
            int[] nArray3 = raster.getSamples(0, 0, n2, n3, 1, (int[])null);
            int[] nArray4 = raster.getSamples(0, 0, n2, n3, 2, (int[])null);
            int[] nArray5 = raster.getSamples(0, 0, n2, n3, 3, (int[])null);
            int n4 = 0;
            int n5 = nArray2.length;
            while (n4 < n5) {
                float f = nArray5[n4];
                float f2 = nArray2[n4];
                float f3 = nArray3[n4];
                float f4 = nArray4[n4];
                float f5 = f2 + 1.402f * (f4 - 128.0f) - f;
                float f6 = f2 - 0.34414f * (f3 - 128.0f) - 0.71414f * (f4 - 128.0f) - f;
                float f7 = f2 + 1.772f * (f3 - 128.0f) - f;
                nArray[n4] = (0xFF & (f5 < 0.0f ? 0 : (f5 > 255.0f ? 255 : (int)(f5 + 0.5f)))) << 16 | (0xFF & (f6 < 0.0f ? 0 : (f6 > 255.0f ? 255 : (int)(f6 + 0.5f)))) << 8 | 0xFF & (f7 < 0.0f ? 0 : (f7 > 255.0f ? 255 : (int)(f7 + 0.5f)));
                ++n4;
            }
            WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferInt(nArray, nArray.length), n2, n3, n2, new int[]{0xFF0000, 65280, 255}, null);
            ColorSpace colorSpace2 = ColorSpace.getInstance(1000);
            DirectColorModel directColorModel = new DirectColorModel(colorSpace2, 24, 0xFF0000, 65280, 255, 0, false, 3);
            bufferedImage = new BufferedImage(directColorModel, writableRaster, true, null);
        }
        return bufferedImage;
    }

    private BufferedImage createRGBImageFromCMYK(int n, Raster raster, ColorSpace colorSpace) throws IOException {
        BufferedImage bufferedImage;
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        if (colorSpace != null) {
            ImageTypeSpecifier imageTypeSpecifier = this.getImageTypes(n).next();
            SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
            if (sampleModel.getWidth() != n2 || sampleModel.getHeight() != n3) {
                sampleModel = imageTypeSpecifier.getSampleModel(n2, n3);
            }
            WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, null);
            bufferedImage = new BufferedImage(RGB_COMP, writableRaster, false, null);
            ColorSpace colorSpace2 = bufferedImage.getColorModel().getColorSpace();
            ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, colorSpace2, null);
            colorConvertOp.filter(raster, writableRaster);
        } else {
            int[] nArray = new int[n2 * n3];
            int[] nArray2 = raster.getSamples(0, 0, n2, n3, 0, (int[])null);
            int[] nArray3 = raster.getSamples(0, 0, n2, n3, 1, (int[])null);
            int[] nArray4 = raster.getSamples(0, 0, n2, n3, 2, (int[])null);
            int[] nArray5 = raster.getSamples(0, 0, n2, n3, 3, (int[])null);
            int n4 = 0;
            int n5 = nArray2.length;
            while (n4 < n5) {
                int n6 = nArray5[n4];
                nArray[n4] = 255 - Math.min(255, nArray2[n4] + n6) << 16 | 255 - Math.min(255, nArray3[n4] + n6) << 8 | 255 - Math.min(255, nArray4[n4] + n6);
                ++n4;
            }
            WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferInt(nArray, nArray.length), n2, n3, n2, new int[]{0xFF0000, 65280, 255}, null);
            ColorSpace colorSpace3 = ColorSpace.getInstance(1000);
            DirectColorModel directColorModel = new DirectColorModel(colorSpace3, 24, 0xFF0000, 65280, 255, 0, false, 3);
            bufferedImage = new BufferedImage(directColorModel, writableRaster, true, null);
        }
        return bufferedImage;
    }

    private BufferedImage createRGBAImageFromRGBA(int n, Raster raster, ColorSpace colorSpace) throws IOException {
        BufferedImage bufferedImage;
        if (raster.getSampleModel().getNumBands() != 4) {
            throw new IllegalArgumentException(new ToString().append("Unexpected sample model: ", raster.getSampleModel()).toString());
        }
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        colorSpace = null;
        if (colorSpace != null) {
            bufferedImage = new BufferedImage(n2, n3, 1);
            WritableRaster writableRaster = bufferedImage.getRaster();
            ColorSpace colorSpace2 = bufferedImage.getColorModel().getColorSpace();
            ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, colorSpace2, null);
            colorConvertOp.filter(raster, writableRaster);
        } else {
            DataBuffer dataBuffer = raster.getDataBuffer();
            if (dataBuffer instanceof DataBufferByte) {
                ImageTypeSpecifier imageTypeSpecifier = this.getImageTypes(n).next();
                SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
                if (sampleModel.getWidth() != n2 || sampleModel.getHeight() != n3) {
                    sampleModel = imageTypeSpecifier.getSampleModel(n2, n3);
                }
                if (sampleModel.getNumBands() == 3) {
                    DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                    byte[] byArray = dataBufferByte.getData();
                    WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, null);
                    DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
                    byte[] byArray2 = dataBufferByte2.getData();
                    int n4 = 0;
                    int n5 = 0;
                    while (n4 < byArray2.length) {
                        int n6 = 0xFF & byArray[n5 + 3];
                        byArray2[n4] = (byte)((0xFF & byArray[n5]) * n6 / 255);
                        byArray2[n4 + 1] = (byte)((0xFF & byArray[n5 + 1]) * n6 / 255);
                        byArray2[n4 + 2] = (byte)((0xFF & byArray[n5 + 2]) * n6 / 255);
                        n4 += 3;
                        n5 += 4;
                    }
                    bufferedImage = new BufferedImage(RGB_COMP, writableRaster, false, null);
                } else {
                    bufferedImage = new BufferedImage(imageTypeSpecifier.getColorModel(), (WritableRaster)raster, false, null);
                }
            } else {
                if (LOG.isInfoEnabled()) {
                    LOG.warn("CMYK JPEG reader: Non-optimal conversion " + raster);
                }
                int[] nArray = new int[n2 * n3];
                int[] nArray2 = raster.getSamples(0, 0, n2, n3, 0, (int[])null);
                int[] nArray3 = raster.getSamples(0, 0, n2, n3, 1, (int[])null);
                int[] nArray4 = raster.getSamples(0, 0, n2, n3, 2, (int[])null);
                int[] nArray5 = raster.getSamples(0, 0, n2, n3, 3, (int[])null);
                int n7 = 0;
                int n8 = nArray2.length;
                while (n7 < n8) {
                    nArray[n7] = nArray5[n7] << 24 | nArray2[n7] << 16 | nArray3[n7] << 8 | nArray4[n7];
                    ++n7;
                }
                WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferInt(nArray, nArray.length), n2, n3, n2, new int[]{0xFF0000, 65280, 255, -16777216}, null);
                ColorSpace colorSpace3 = ColorSpace.getInstance(1000);
                DirectColorModel directColorModel = new DirectColorModel(colorSpace3, 32, 0xFF0000, 65280, 255, -16777216, false, 3);
                bufferedImage = new BufferedImage(directColorModel, writableRaster, true, null);
            }
        }
        return bufferedImage;
    }

    private static synchronized void buildYCCtoRGBtable() {
        if (Cr_r_tab[0] == 0) {
            int n = 0;
            int n2 = -128;
            while (n <= 255) {
                CMYKJPEGImageReader.Cr_r_tab[n] = (int)(91881.972 * (double)n2 + 32768.0) >> 16;
                CMYKJPEGImageReader.Cb_b_tab[n] = (int)(116130.292 * (double)n2 + 32768.0) >> 16;
                CMYKJPEGImageReader.Cr_g_tab[n] = -46802 * n2;
                CMYKJPEGImageReader.Cb_g_tab[n] = -22554 * n2 + 32768;
                ++n;
                ++n2;
            }
        }
    }

    private Raster convertInvertedYCCKToCMYK(Raster raster) throws IOException {
        WritableRaster writableRaster;
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
            byte[] byArray = dataBufferByte.getData();
            byte[] byArray2 = new byte[n * n2 * 4];
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4 = 255 - (0xFF & byArray[n3]);
                int n5 = 255 - (0xFF & byArray[n3 + 1]);
                int n6 = 255 - (0xFF & byArray[n3 + 2]);
                int n7 = 255 - (0xFF & byArray[n3 + 3]);
                int n8 = 255 - (n4 + Cr_r_tab[n6]);
                int n9 = 255 - (n4 + (Cb_g_tab[n5] + Cr_g_tab[n6] >> 16));
                int n10 = 255 - (n4 + Cb_b_tab[n5]);
                byArray2[n3] = (byte)(n8 < 0 ? 0 : (n8 > 255 ? 255 : n8));
                byArray2[n3 + 1] = (byte)(n9 < 0 ? 0 : (n9 > 255 ? 255 : n9));
                byArray2[n3 + 2] = (byte)(n10 < 0 ? 0 : (n10 > 255 ? 255 : n10));
                byArray2[n3 + 3] = (byte)n7;
                n3 += 4;
            }
            DataBufferByte dataBufferByte2 = new DataBufferByte(byArray2, byArray2.length);
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            writableRaster = Raster.createInterleavedRaster(dataBufferByte2, n, n2, n * 4, 4, nArray, null);
        } else {
            int[] nArray = raster.getSamples(0, 0, n, n2, 0, (int[])null);
            int[] nArray2 = raster.getSamples(0, 0, n, n2, 1, (int[])null);
            int[] nArray3 = raster.getSamples(0, 0, n, n2, 2, (int[])null);
            int[] nArray4 = raster.getSamples(0, 0, n, n2, 3, (int[])null);
            int[] nArray5 = new int[nArray.length];
            int n11 = 0;
            while (n11 < nArray.length) {
                int n12 = 255 - nArray[n11];
                int n13 = 255 - nArray2[n11];
                int n14 = 255 - nArray3[n11];
                int n15 = 255 - (n12 + Cr_r_tab[n14]);
                int n16 = 255 - (n12 + (Cb_g_tab[n13] + Cr_g_tab[n14] >> 16));
                int n17 = 255 - (n12 + Cb_b_tab[n13]);
                nArray5[n11] = (n15 < 0 ? 0 : (n15 > 255 ? 255 : n15)) << 24 | (n16 < 0 ? 0 : (n16 > 255 ? 255 : n16)) << 16 | (n17 < 0 ? 0 : (n17 > 255 ? 255 : n17)) << 8 | 255 - nArray4[n11];
                ++n11;
            }
            writableRaster = Raster.createPackedRaster(new DataBufferInt(nArray5, nArray5.length), n, n2, n, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
        }
        return writableRaster;
    }

    private static Raster convertYCCKtoCMYK(Raster raster) {
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        int[] nArray = raster.getSamples(0, 0, n, n2, 0, (int[])null);
        int[] nArray2 = raster.getSamples(0, 0, n, n2, 1, (int[])null);
        int[] nArray3 = raster.getSamples(0, 0, n, n2, 2, (int[])null);
        int[] nArray4 = raster.getSamples(0, 0, n, n2, 3, (int[])null);
        int[] nArray5 = new int[nArray.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[n3];
            int n5 = nArray2[n3];
            int n6 = nArray3[n3];
            int n7 = 255 - (n4 + Cr_r_tab[n6]);
            int n8 = 255 - (n4 + (Cb_g_tab[n5] + Cr_g_tab[n6] >> 16));
            int n9 = 255 - (n4 + Cb_b_tab[n5]);
            nArray5[n3] = (n7 < 0 ? 0 : (n7 > 255 ? 255 : n7)) << 24 | (n8 < 0 ? 0 : (n8 > 255 ? 255 : n8)) << 16 | (n9 < 0 ? 0 : (n9 > 255 ? 255 : n9)) << 8 | nArray4[n3];
            ++n3;
        }
        return Raster.createPackedRaster(new DataBufferInt(nArray5, nArray5.length), n, n2, n, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
    }

    private BufferedImage readImageFromYUVorGray(int n, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = this.nativeReader.read(n, imageReadParam);
        return bufferedImage;
    }
}

