/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.io;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;

public class ByteArrayImageInputStream
extends ImageInputStreamImpl {
    protected byte[] buf;
    protected int count;
    private final int arrayOffset;

    public ByteArrayImageInputStream(byte[] byArray) {
        this(byArray, ByteOrder.BIG_ENDIAN);
    }

    public ByteArrayImageInputStream(byte[] byArray, ByteOrder byteOrder) {
        this(byArray, 0, byArray.length, byteOrder);
    }

    public ByteArrayImageInputStream(byte[] byArray, int n, int n2, ByteOrder byteOrder) {
        this.buf = byArray;
        this.streamPos = n;
        this.count = Math.min(n + n2, byArray.length);
        this.arrayOffset = n;
        this.byteOrder = byteOrder;
    }

    @Override
    public synchronized int read() {
        this.flushBits();
        return this.streamPos < (long)this.count ? this.buf[(int)this.streamPos++] & 0xFF : -1;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) {
        this.flushBits();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.streamPos >= (long)this.count) {
            return -1;
        }
        if (this.streamPos + (long)n2 > (long)this.count) {
            n2 = (int)((long)this.count - this.streamPos);
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, (int)this.streamPos, byArray, n, n2);
        this.streamPos += (long)n2;
        return n2;
    }

    public synchronized long skip(long l) {
        if (this.streamPos + l > (long)this.count) {
            l = (long)this.count - this.streamPos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.streamPos += l;
        return l;
    }

    public synchronized int available() {
        return (int)((long)this.count - this.streamPos);
    }

    @Override
    public void close() {
    }

    @Override
    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos - (long)this.arrayOffset;
    }

    @Override
    public void seek(long l) throws IOException {
        this.checkClosed();
        this.flushBits();
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.streamPos = l + (long)this.arrayOffset;
    }

    private void flushBits() {
        this.bitOffset = 0;
    }

    @Override
    public long length() {
        return this.count - this.arrayOffset;
    }
}

