/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.html.internal.ui;

import com.deltawalker.UriInfo;
import com.deltawalker.html.internal.ui.HtmlContextId;
import com.deltawalker.html.internal.ui.HtmlDiffView;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.script.Role;
import com.deltawalker.ui.ContentArea;
import com.deltawalker.ui.DiffView;
import org.apache.commons.httpclient.URI;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;

public class HtmlContentArea
extends ContentArea {
    private Browser browser;

    public HtmlContentArea(Composite composite, int n, HtmlDiffView htmlDiffView, Role role) {
        super(composite, n, (DiffView)htmlDiffView, role);
    }

    public void dispose() {
        this.browser = null;
        super.dispose();
    }

    protected String getHelpContextId() {
        return HtmlContextId.HTML_COMPARISON_WINDOW;
    }

    public Browser scrollable() {
        if (this.browser == null) {
            this.browser = new Browser((Composite)this, 0);
            this.postPopulate();
            this.updateBrowserContent(this.deltaView().doc(this.role));
        }
        return this.browser;
    }

    public void updateBrowserContent(IDoc iDoc) {
        UriInfo uriInfo;
        if (this.browser != null && iDoc != null && !(uriInfo = iDoc.uriInfo()).hasError() && !uriInfo.isEmpty()) {
            String string = uriInfo.uri();
            try {
                string = new URI(string, false).getEscapedURI();
            }
            catch (Throwable throwable) {}
            String string2 = this.browser.getUrl();
            if (!string2.endsWith(string)) {
                this.browser.setUrl(uriInfo.uri());
            } else {
                this.browser.refresh();
            }
        }
    }
}

