/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.xml.internal.ui;

import com.deltawalker.App;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.ui.ColumnBoss;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.ui.CompareEditor;
import com.deltawalker.ui.DiffController;
import com.deltawalker.ui.DiffView;
import com.deltawalker.xml.internal.ui.XmlColumnBoss;
import com.deltawalker.xml.internal.ui.XmlContentArea;
import com.deltawalker.xml.internal.ui.XmlDiffController;
import com.deltopia.jface.util.IActiveViewListener;
import com.deltopia.jface.util.IViewHolder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDiffView
extends StructDiffView {
    private static final Logger LOG = LoggerFactory.getLogger(XmlDiffView.class);
    public static final int XML_VIEW_INDEX = 1;
    private boolean expand = true;
    private IActiveViewListener onView;
    private IViewHolder viewHolder;

    public XmlDiffView(Composite composite, int n) {
        super(composite, n);
        if (LOG.isInfoEnabled()) {
            LOG.info("C-tor: " + XmlDiffView.class.getSimpleName());
        }
        this.installListeners(true);
    }

    public boolean canCopyFrom(boolean bl, Role role, Role role2) {
        return false;
    }

    public XmlColumnBoss columnBoss(Role role) {
        ColumnBoss columnBoss = (ColumnBoss)this.colBosses.get(role);
        if (columnBoss == null) {
            columnBoss = new XmlColumnBoss(this);
            columnBoss.setExpandColumnTitle(StructMsg.XmlView_expandColumnTitle);
            columnBoss.setShowDiffsColumn(false);
            this.colBosses.put(role, columnBoss);
        }
        return (XmlColumnBoss)columnBoss;
    }

    public void compare() {
        if (!this.getInput().isWorking()) {
            DiffView diffView = (DiffView)this.viewHolder.view(0, false);
            App.instance().viewBoss().viewDoc(diffView, true, null, null, false, true);
        }
    }

    protected XmlContentArea createContentArea(Composite composite, Role role) {
        return new XmlContentArea(composite, 0, (DiffView)this, role);
    }

    protected DiffController createController() {
        return new XmlDiffController();
    }

    public void dispose() {
        try {
            if (this.viewHolder != null) {
                this.viewHolder.removeActiveViewListener(this.onView);
                this.viewHolder = null;
                this.onView = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    public String getDoneMessage() {
        return StructMsg.StructDiffModelListener_doneXml;
    }

    public Image getImage() {
        return ImageCache.getImage((String)ImageConst.XML_STRUCTURE);
    }

    public int getOrientation() {
        return this.orientation;
    }

    private void installListeners(boolean bl) {
        if (!bl) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
        if (!(iWorkbenchPart instanceof CompareEditor)) {
            return;
        }
        this.viewHolder = ((CompareEditor)iWorkbenchPart).viewHolder();
        this.onView = new IActiveViewListener(){

            public void activeViewerChanged(IViewHolder iViewHolder, int n, int n2) {
                XmlDiffView.this.onActiveViewChanged(iViewHolder, n2);
            }
        };
        this.viewHolder.addActiveViewListener(this.onView);
    }

    private void onActiveViewChanged(IViewHolder iViewHolder, int n) {
        IStructDiffModel iStructDiffModel = this.deltaModel();
        if (iStructDiffModel != null) {
            boolean bl;
            boolean bl2 = bl = n == 1;
            if (bl && this.expand) {
                this.controller().getAction("com.deltawalker.structure.expandDiffs").run();
                this.expand = false;
            }
        }
    }

    public int triadIndex() {
        return 1;
    }
}

