/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.xml.internal;

import com.deltawalker.IStructElement;
import com.deltawalker.NotifyUtil;
import com.deltawalker.StructException;
import com.deltawalker.interfaces.IContentChangeNotifier;
import com.deltawalker.interfaces.IFileContentListener;
import com.deltawalker.xml.XMLMessages;
import com.deltawalker.xml.internal.SaxEventHandler;
import com.deltawalker.xml.internal.XmlContainerNode;
import com.deltopia.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDocument
extends XmlContainerNode
implements IContentChangeNotifier {
    private IDocument doc;
    private IDocumentListener onDoc;
    private boolean parsePending;
    private final String uri;

    public XmlDocument(IDocument iDocument, String string) throws IOException, StructException {
        super(null, XMLMessages.XmlNode_docType);
        this.doc = iDocument;
        this.uri = string;
        this.hookDocument();
        this.parse(this.doc.get());
    }

    public void addContentChangeListener(IFileContentListener iFileContentListener) {
        this.addListenerObject(iFileContentListener);
    }

    @Override
    public void dispose() {
        if (this.onDoc != null) {
            this.doc.removeDocumentListener(this.onDoc);
            this.onDoc = null;
        }
        this.doc = null;
    }

    private void fireContentChanged(IStructElement iStructElement, boolean bl) {
        NotifyUtil.fireContentChanged((Object[])this.getListeners(), (IStructElement)iStructElement, (boolean)bl);
    }

    @Override
    public IStructElement[] getChildren(IProgressMonitor iProgressMonitor) throws IOException {
        if (this.parsePending) {
            this.parse(this.doc.get());
        }
        return super.getChildren(iProgressMonitor);
    }

    public XmlDocument getDocument() {
        return this;
    }

    public String getName() {
        return this.uri != null ? new File(this.uri).getName() : null;
    }

    private void hookDocument() {
        if (!this.doc.containsPositionCategory("DocumentRangeCategory")) {
            this.doc.addPositionCategory("DocumentRangeCategory");
        }
        this.doc.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("DocumentRangeCategory"));
        if (this.onDoc == null) {
            this.onDoc = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent documentEvent) {
                }

                public void documentChanged(DocumentEvent documentEvent) {
                    XmlDocument.this.parsePending = true;
                    XmlDocument.this.fireContentChanged(null, true);
                }
            };
        }
        this.doc.addDocumentListener(this.onDoc);
    }

    private void parse(String string) throws IOException {
        this.parsePending = false;
        SaxEventHandler saxEventHandler = new SaxEventHandler(this);
        if (StringUtil.isEmpty((String)string)) {
            saxEventHandler.startDocument();
            saxEventHandler.endDocument();
            return;
        }
        StringReader stringReader = new StringReader(string);
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(stringReader), (DefaultHandler)saxEventHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
    }

    public void removeContentChangeListener(IFileContentListener iFileContentListener) {
        this.removeListenerObject(iFileContentListener);
    }

    public String toString() {
        return this.getName();
    }
}

