/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.xml.internal;

import com.deltawalker.xml.internal.XmlCharData;
import com.deltawalker.xml.internal.XmlContainerNode;
import com.deltawalker.xml.internal.XmlDocument;
import com.deltawalker.xml.internal.XmlElement;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SaxEventHandler
extends DefaultHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(SaxEventHandler.class);
    private List<XmlContainerNode> parents = new LinkedList<XmlContainerNode>();

    public SaxEventHandler(XmlDocument xmlDocument) {
        this.parents.add(xmlDocument);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            char c = cArray[n3];
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r' && c != '\f' && c != '\u000b') break;
            ++n3;
        }
        if (n3 >= n4) {
            return;
        }
        new XmlCharData(this.getParent(), String.valueOf(cArray, n, n2));
    }

    @Override
    public void endDocument() {
        this.parents = null;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.parents.remove(this.parents.size() - 1);
    }

    private XmlContainerNode getParent() {
        return this.parents.get(this.parents.size() - 1);
    }

    @Override
    public void startDocument() {
        this.parents.get(0).removeChildren();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("uri=" + string + "    localName=" + string2 + "    qName=" + string3);
        }
        XmlElement xmlElement = new XmlElement(this.getParent(), string, string2, string3, attributes);
        this.parents.add(xmlElement);
    }
}

