/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.themes;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ColorUtil {
    private static Field[] cachedFields;

    private static RGB process(String string) {
        Field[] fieldArray = ColorUtil.getFields();
        try {
            int n = 0;
            while (n < fieldArray.length) {
                Field field = fieldArray[n];
                if (field.getName().equals(string)) {
                    return ColorUtil.getSystemColor(field.getInt(null));
                }
                ++n;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return ColorUtil.getSystemColor(2);
    }

    private static Field[] getFields() {
        if (cachedFields == null) {
            Class<SWT> clazz = SWT.class;
            Field[] fieldArray = clazz.getDeclaredFields();
            ArrayList<Field> arrayList = new ArrayList<Field>(fieldArray.length);
            int n = 0;
            while (n < fieldArray.length) {
                Field field = fieldArray[n];
                if (field.getType() == Integer.TYPE && Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && field.getName().startsWith("COLOR")) {
                    arrayList.add(field);
                }
                ++n;
            }
            cachedFields = arrayList.toArray(new Field[arrayList.size()]);
        }
        return cachedFields;
    }

    public static RGB blend(RGB rGB, RGB rGB2, int n) {
        int n2 = ColorUtil.blend(rGB.red, rGB2.red, n);
        int n3 = ColorUtil.blend(rGB.green, rGB2.green, n);
        int n4 = ColorUtil.blend(rGB.blue, rGB2.blue, n);
        return new RGB(n2, n3, n4);
    }

    private static int blend(int n, int n2, int n3) {
        int n4 = (n3 * n + (100 - n3) * n2) / 100;
        return Math.min(255, n4);
    }

    public static RGB blend(RGB rGB, RGB rGB2) {
        int n = ColorUtil.blend(rGB.red, rGB2.red);
        int n2 = ColorUtil.blend(rGB.green, rGB2.green);
        int n3 = ColorUtil.blend(rGB.blue, rGB2.blue);
        return new RGB(n, n2, n3);
    }

    private static int blend(int n, int n2) {
        return Math.abs(n - n2) / 2 + Math.min(n, n2);
    }

    private static RGB getSystemColor(int n) {
        return Display.getCurrent().getSystemColor(n).getRGB();
    }

    public static RGB getColorValue(String string) throws DataFormatException {
        if (string == null) {
            return null;
        }
        if (!ColorUtil.isDirectValue(string = string.trim())) {
            return ColorUtil.process(string);
        }
        return StringConverter.asRGB((String)string);
    }

    public static RGB[] getColorValues(String[] stringArray) {
        RGB[] rGBArray = new RGB[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            rGBArray[n] = ColorUtil.getColorValue(stringArray[n]);
            ++n;
        }
        return rGBArray;
    }

    private static boolean isDirectValue(String string) {
        return string.indexOf(44) >= 0;
    }

    private ColorUtil() {
    }
}

