/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.statushandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchErrorHandlerProxy;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.statushandlers.StatusHandlerRegistry;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class StatusManager {
    public static final int NONE = 0;
    public static final int LOG = 1;
    public static final int SHOW = 2;
    public static final int BLOCK = 4;
    private static StatusManager MANAGER;
    private AbstractStatusHandler statusHandler;
    private List loggedStatuses = new ArrayList();
    private ListenerList listeners = new ListenerList();

    public static StatusManager getManager() {
        if (MANAGER == null) {
            MANAGER = new StatusManager();
        }
        return MANAGER;
    }

    private StatusManager() {
        Platform.addLogListener((ILogListener)new StatusManagerLogListener());
    }

    private AbstractStatusHandler getStatusHandler() {
        if (this.statusHandler == null && StatusHandlerRegistry.getDefault().getDefaultHandlerDescriptor() != null) {
            try {
                this.statusHandler = StatusHandlerRegistry.getDefault().getDefaultHandlerDescriptor().getStatusHandler();
            }
            catch (CoreException coreException) {
                this.logError("Errors during the default handler creating", coreException);
            }
        }
        if (this.statusHandler == null) {
            this.statusHandler = new WorkbenchErrorHandlerProxy();
        }
        return this.statusHandler;
    }

    public void handle(StatusAdapter statusAdapter, int n) {
        try {
            if (statusAdapter == null) {
                this.logError("Error occurred during status handling", new NullPointerException("StatusAdapter object is null"));
                return;
            }
            if (statusAdapter.getStatus() == null) {
                this.logError("Error occurred during status handling", new NullPointerException("Status object is null"));
                return;
            }
            if (!PlatformUI.isWorkbenchRunning()) {
                if (n != 0) {
                    this.logError(statusAdapter.getStatus());
                }
                return;
            }
            this.getStatusHandler().handle(statusAdapter, n);
            if (!this.getStatusHandler().supportsNotification(1)) {
                this.generateFakeNotification(statusAdapter, n);
            }
        }
        catch (Throwable throwable) {
            this.logError(statusAdapter.getStatus());
            this.logError("Error occurred during status handling", throwable);
        }
    }

    public void handle(StatusAdapter statusAdapter) {
        this.handle(statusAdapter, 1);
    }

    public void handle(IStatus iStatus, int n) {
        StatusAdapter statusAdapter = new StatusAdapter(iStatus);
        this.handle(statusAdapter, n);
    }

    public void handle(IStatus iStatus) {
        this.handle(iStatus, 1);
    }

    public void handle(CoreException coreException, String string) {
        this.handle((IStatus)new Status(2, string, coreException.getLocalizedMessage(), (Throwable)coreException));
    }

    public void addLoggedStatus(IStatus iStatus) {
        this.loggedStatuses.add(iStatus);
    }

    private void logError(String string, Throwable throwable) {
        IStatus iStatus = StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, string, throwable);
        this.addLoggedStatus(iStatus);
        WorkbenchPlugin.log(iStatus);
    }

    private void logError(IStatus iStatus) {
        this.addLoggedStatus(iStatus);
        WorkbenchPlugin.log(iStatus);
    }

    public void fireNotification(int n, StatusAdapter[] statusAdapterArray) {
        if (this.getStatusHandler().supportsNotification(n)) {
            this.doFireNotification(n, statusAdapterArray);
        }
    }

    private void doFireNotification(int n, StatusAdapter[] statusAdapterArray) {
        Object[] objectArray = this.listeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof INotificationListener) {
                ((INotificationListener)objectArray[n2]).statusManagerNotified(n, statusAdapterArray);
            }
            ++n2;
        }
    }

    private void generateFakeNotification(StatusAdapter statusAdapter, int n) {
        if (((n & 2) == 2 || (n & 4) == 4) && statusAdapter.getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY) != Boolean.TRUE) {
            this.doFireNotification(1, new StatusAdapter[]{statusAdapter});
        }
    }

    public void addListener(INotificationListener iNotificationListener) {
        this.listeners.add((Object)iNotificationListener);
    }

    public void removeListener(INotificationListener iNotificationListener) {
        this.listeners.remove((Object)iNotificationListener);
    }

    public static interface INotificationListener {
        public void statusManagerNotified(int var1, StatusAdapter[] var2);
    }

    public static interface INotificationTypes {
        public static final int HANDLED = 1;
    }

    private class StatusManagerLogListener
    implements ILogListener {
        private StatusManagerLogListener() {
        }

        public void logging(IStatus iStatus, String string) {
            if (!StatusManager.this.loggedStatuses.contains(iStatus)) {
                StatusManager.this.handle(iStatus, 0);
            } else {
                StatusManager.this.loggedStatuses.remove(iStatus);
            }
        }
    }
}

