/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.splash;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.splash.AbstractSplashHandler;

public abstract class BasicSplashHandler
extends AbstractSplashHandler {
    private Color foreground = null;
    private AbsolutePositionProgressMonitorPart monitor;
    private Rectangle messageRect;
    private Rectangle progressRect;

    @Override
    public IProgressMonitor getBundleProgressMonitor() {
        if (this.monitor == null) {
            Composite composite = new Composite((Composite)this.getSplash(), Window.getDefaultOrientation());
            Point point = this.getSplash().getSize();
            composite.setBounds(new Rectangle(0, 0, point.x, point.y));
            this.monitor = new AbsolutePositionProgressMonitorPart(composite);
            this.monitor.setSize(point);
            if (this.progressRect != null) {
                this.monitor.getProgressIndicator().setBounds(this.progressRect);
            } else {
                this.monitor.getProgressIndicator().setVisible(false);
            }
            if (this.messageRect != null) {
                this.monitor.getProgressText().setBounds(this.messageRect);
            } else {
                this.monitor.getProgressText().setVisible(false);
            }
            if (this.foreground != null) {
                this.monitor.getProgressText().setForeground(this.foreground);
            }
            this.monitor.setBackgroundMode(2);
            this.monitor.setBackgroundImage(this.getSplash().getShell().getBackgroundImage());
        }
        return this.monitor;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.foreground != null) {
            this.foreground.dispose();
        }
    }

    protected void setForeground(RGB rGB) {
        if (this.monitor != null) {
            return;
        }
        if (this.foreground != null) {
            this.foreground.dispose();
        }
        this.foreground = new Color((Device)this.getSplash().getShell().getDisplay(), rGB);
    }

    protected Color getForeground() {
        return this.foreground;
    }

    protected void setMessageRect(Rectangle rectangle) {
        this.messageRect = rectangle;
    }

    protected void setProgressRect(Rectangle rectangle) {
        this.progressRect = rectangle;
    }

    protected Composite getContent() {
        return (Composite)this.getBundleProgressMonitor();
    }

    private void updateUI(final Runnable runnable) {
        Shell shell = this.getSplash();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (Thread.currentThread() == display.getThread()) {
            runnable.run();
        } else {
            StartupThreading.StartupRunnable startupRunnable = new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    runnable.run();
                }
            };
            display.asyncExec((Runnable)startupRunnable);
        }
    }

    class AbsolutePositionProgressMonitorPart
    extends ProgressMonitorPart {
        public AbsolutePositionProgressMonitorPart(Composite composite) {
            super(composite, null);
            this.setLayout(null);
        }

        public ProgressIndicator getProgressIndicator() {
            return this.fProgressIndicator;
        }

        public Label getProgressText() {
            return this.fLabel;
        }

        public void beginTask(final String string, final int n) {
            BasicSplashHandler.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (AbsolutePositionProgressMonitorPart.this.isDisposed()) {
                        return;
                    }
                    AbsolutePositionProgressMonitorPart.super.beginTask(string, n);
                }
            });
        }

        public void done() {
            BasicSplashHandler.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (AbsolutePositionProgressMonitorPart.this.isDisposed()) {
                        return;
                    }
                    AbsolutePositionProgressMonitorPart.super.done();
                }
            });
        }

        public void internalWorked(final double d) {
            BasicSplashHandler.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (AbsolutePositionProgressMonitorPart.this.isDisposed()) {
                        return;
                    }
                    AbsolutePositionProgressMonitorPart.super.internalWorked(d);
                }
            });
        }

        public void setFont(final Font font) {
            BasicSplashHandler.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (AbsolutePositionProgressMonitorPart.this.isDisposed()) {
                        return;
                    }
                    AbsolutePositionProgressMonitorPart.super.setFont(font);
                }
            });
        }

        protected void updateLabel() {
            BasicSplashHandler.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (AbsolutePositionProgressMonitorPart.this.isDisposed()) {
                        return;
                    }
                    AbsolutePositionProgressMonitorPart.super.updateLabel();
                }
            });
        }
    }
}

