/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.progress;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.progress.ProgressMessages;

public abstract class UIJob
extends Job {
    private Display cachedDisplay;

    public UIJob(String string) {
        super(string);
    }

    public UIJob(Display display, String string) {
        this(string);
        this.setDisplay(display);
    }

    public static IStatus errorStatus(Throwable throwable) {
        return WorkbenchPlugin.getStatus(throwable);
    }

    public final IStatus run(final IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Display display = this.getDisplay();
        if (display == null || display.isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                block8: {
                    IStatus iStatus = null;
                    Throwable throwable = null;
                    try {
                        try {
                            UIJob.this.setThread(Thread.currentThread());
                            if (iProgressMonitor.isCanceled()) {
                                iStatus = Status.CANCEL_STATUS;
                                break block8;
                            }
                            UIStats.start(13, UIJob.this.getName());
                            iStatus = UIJob.this.runInUIThread(iProgressMonitor);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            UIStats.end(13, (Object)UIJob.this, UIJob.this.getName());
                            if (iStatus == null) {
                                iStatus = new Status(4, "org.eclipse.ui", 4, ProgressMessages.InternalError, throwable);
                            }
                            UIJob.this.done(iStatus);
                        }
                    }
                    finally {
                        UIStats.end(13, (Object)UIJob.this, UIJob.this.getName());
                        if (iStatus == null) {
                            iStatus = new Status(4, "org.eclipse.ui", 4, ProgressMessages.InternalError, throwable);
                        }
                        UIJob.this.done(iStatus);
                    }
                }
            }
        });
        return Job.ASYNC_FINISH;
    }

    public abstract IStatus runInUIThread(IProgressMonitor var1);

    public void setDisplay(Display display) {
        Assert.isNotNull((Object)display);
        this.cachedDisplay = display;
    }

    public Display getDisplay() {
        if (this.cachedDisplay == null && PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return this.cachedDisplay;
    }
}

