/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.progress;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.WorkbenchJob;

public class DeferredTreeContentManager {
    AbstractTreeViewer treeViewer;
    IWorkbenchSiteProgressService progressService;
    private ListenerList updateCompleteListenerList;

    public DeferredTreeContentManager(ITreeContentProvider iTreeContentProvider, AbstractTreeViewer abstractTreeViewer, IWorkbenchPartSite iWorkbenchPartSite) {
        this(abstractTreeViewer, iWorkbenchPartSite);
    }

    public DeferredTreeContentManager(ITreeContentProvider iTreeContentProvider, AbstractTreeViewer abstractTreeViewer) {
        this(abstractTreeViewer);
    }

    public DeferredTreeContentManager(AbstractTreeViewer abstractTreeViewer, IWorkbenchPartSite iWorkbenchPartSite) {
        this(abstractTreeViewer);
        Object object = Util.getAdapter(iWorkbenchPartSite, IWorkbenchSiteProgressService.class);
        if (object != null) {
            this.progressService = (IWorkbenchSiteProgressService)object;
        }
    }

    public DeferredTreeContentManager(AbstractTreeViewer abstractTreeViewer) {
        this.treeViewer = abstractTreeViewer;
    }

    public boolean mayHaveChildren(Object object) {
        Assert.isNotNull((Object)object, (String)ProgressMessages.DeferredTreeContentManager_NotDeferred);
        IDeferredWorkbenchAdapter iDeferredWorkbenchAdapter = this.getAdapter(object);
        return iDeferredWorkbenchAdapter != null && iDeferredWorkbenchAdapter.isContainer();
    }

    public Object[] getChildren(Object object) {
        IDeferredWorkbenchAdapter iDeferredWorkbenchAdapter = this.getAdapter(object);
        if (iDeferredWorkbenchAdapter == null) {
            return null;
        }
        PendingUpdateAdapter pendingUpdateAdapter = this.createPendingUpdateAdapter();
        this.startFetchingDeferredChildren(object, iDeferredWorkbenchAdapter, pendingUpdateAdapter);
        return new Object[]{pendingUpdateAdapter};
    }

    protected PendingUpdateAdapter createPendingUpdateAdapter() {
        return new PendingUpdateAdapter();
    }

    protected IDeferredWorkbenchAdapter getAdapter(Object object) {
        return (IDeferredWorkbenchAdapter)Util.getAdapter(object, IDeferredWorkbenchAdapter.class);
    }

    protected void startFetchingDeferredChildren(final Object object, final IDeferredWorkbenchAdapter iDeferredWorkbenchAdapter, final PendingUpdateAdapter pendingUpdateAdapter) {
        final IElementCollector iElementCollector = this.createElementCollector(object, pendingUpdateAdapter);
        this.cancel(object);
        String string = this.getFetchJobName(object, iDeferredWorkbenchAdapter);
        Job job = new Job(string){

            public IStatus run(IProgressMonitor iProgressMonitor) {
                iDeferredWorkbenchAdapter.fetchDeferredChildren(object, iElementCollector, iProgressMonitor);
                if (iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object object2) {
                if (object2 instanceof DeferredContentFamily) {
                    DeferredContentFamily deferredContentFamily = (DeferredContentFamily)object2;
                    if (deferredContentFamily.manager == DeferredTreeContentManager.this) {
                        return this.isParent(deferredContentFamily, object);
                    }
                }
                return false;
            }

            private boolean isParent(DeferredContentFamily deferredContentFamily, Object object3) {
                if (deferredContentFamily.element.equals(object3)) {
                    return true;
                }
                IWorkbenchAdapter iWorkbenchAdapter = this.getWorkbenchAdapter(object3);
                if (iWorkbenchAdapter == null) {
                    return false;
                }
                Object object2 = iWorkbenchAdapter.getParent(object3);
                if (object2 == null) {
                    return false;
                }
                return this.isParent(deferredContentFamily, object2);
            }

            private IWorkbenchAdapter getWorkbenchAdapter(Object object2) {
                return (IWorkbenchAdapter)Util.getAdapter(object2, IWorkbenchAdapter.class);
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                DeferredTreeContentManager.this.runClearPlaceholderJob(pendingUpdateAdapter);
            }
        });
        job.setRule(iDeferredWorkbenchAdapter.getRule(object));
        if (this.progressService == null) {
            job.schedule();
        } else {
            this.progressService.schedule(job);
        }
    }

    protected String getFetchJobName(Object object, IDeferredWorkbenchAdapter iDeferredWorkbenchAdapter) {
        return NLS.bind((String)ProgressMessages.DeferredTreeContentManager_FetchingName, (Object)iDeferredWorkbenchAdapter.getLabel(object));
    }

    protected void addChildren(final Object object, final Object[] objectArray, IProgressMonitor iProgressMonitor) {
        WorkbenchJob workbenchJob = new WorkbenchJob(ProgressMessages.DeferredTreeContentManager_AddingChildren){

            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                if (DeferredTreeContentManager.this.treeViewer.getControl().isDisposed() || iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                DeferredTreeContentManager.this.treeViewer.add(object, objectArray);
                return Status.OK_STATUS;
            }
        };
        workbenchJob.setSystem(true);
        workbenchJob.schedule();
    }

    public boolean isDeferredAdapter(Object object) {
        return this.getAdapter(object) != null;
    }

    protected void runClearPlaceholderJob(final PendingUpdateAdapter pendingUpdateAdapter) {
        if (pendingUpdateAdapter.isRemoved() || !PlatformUI.isWorkbenchRunning()) {
            return;
        }
        WorkbenchJob workbenchJob = new WorkbenchJob(ProgressMessages.DeferredTreeContentManager_ClearJob){

            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                if (!pendingUpdateAdapter.isRemoved()) {
                    Control control = DeferredTreeContentManager.this.treeViewer.getControl();
                    if (control.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    DeferredTreeContentManager.this.treeViewer.remove((Object)pendingUpdateAdapter);
                    pendingUpdateAdapter.setRemoved(true);
                }
                return Status.OK_STATUS;
            }
        };
        workbenchJob.setSystem(true);
        if (this.updateCompleteListenerList != null) {
            Object[] objectArray = this.updateCompleteListenerList.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                workbenchJob.addJobChangeListener((IJobChangeListener)objectArray[n]);
                ++n;
            }
        }
        workbenchJob.schedule();
    }

    public void cancel(Object object) {
        if (object == null) {
            return;
        }
        Job.getJobManager().cancel((Object)new DeferredContentFamily(this, object));
    }

    protected IElementCollector createElementCollector(final Object object, final PendingUpdateAdapter pendingUpdateAdapter) {
        return new IElementCollector(){

            @Override
            public void add(Object object2, IProgressMonitor iProgressMonitor) {
                this.add(new Object[]{object2}, iProgressMonitor);
            }

            @Override
            public void add(Object[] objectArray, IProgressMonitor iProgressMonitor) {
                DeferredTreeContentManager.this.addChildren(object, objectArray, iProgressMonitor);
            }

            @Override
            public void done() {
                DeferredTreeContentManager.this.runClearPlaceholderJob(pendingUpdateAdapter);
            }
        };
    }

    public void addUpdateCompleteListener(IJobChangeListener iJobChangeListener) {
        if (iJobChangeListener == null && this.updateCompleteListenerList != null) {
            Object[] objectArray = this.updateCompleteListenerList.getListeners();
            if (objectArray.length == 1) {
                this.removeUpdateCompleteListener((IJobChangeListener)objectArray[0]);
            }
        } else {
            if (this.updateCompleteListenerList == null) {
                this.updateCompleteListenerList = new ListenerList();
            }
            this.updateCompleteListenerList.add((Object)iJobChangeListener);
        }
    }

    public void removeUpdateCompleteListener(IJobChangeListener iJobChangeListener) {
        if (this.updateCompleteListenerList != null) {
            this.updateCompleteListenerList.remove((Object)iJobChangeListener);
        }
    }

    class DeferredContentFamily {
        protected DeferredTreeContentManager manager;
        protected Object element;

        DeferredContentFamily(DeferredTreeContentManager deferredTreeContentManager2, Object object) {
            this.manager = deferredTreeContentManager2;
            this.element = object;
        }
    }
}

