/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.presentations;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultMultiTabListener;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultSimpleTabListener;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabFolder;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultThemeListener;
import org.eclipse.ui.internal.presentations.defaultpresentation.EmptyTabFolder;
import org.eclipse.ui.internal.presentations.util.ISystemMenu;
import org.eclipse.ui.internal.presentations.util.PresentablePartFolder;
import org.eclipse.ui.internal.presentations.util.StandardEditorSystemMenu;
import org.eclipse.ui.internal.presentations.util.StandardViewSystemMenu;
import org.eclipse.ui.internal.presentations.util.TabbedStackPresentation;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public class WorkbenchPresentationFactory
extends AbstractPresentationFactory {
    private static int editorTabPosition = PlatformUI.getPreferenceStore().getInt("EDITOR_TAB_POSITION");
    private static int viewTabPosition = PlatformUI.getPreferenceStore().getInt("VIEW_TAB_POSITION");

    @Override
    public StackPresentation createEditorPresentation(Composite composite, IStackPresentationSite iStackPresentationSite) {
        int n;
        DefaultTabFolder defaultTabFolder = new DefaultTabFolder(composite, editorTabPosition | 0x800, iStackPresentationSite.supportsState(0), iStackPresentationSite.supportsState(1));
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        if (iPreferenceStore.contains("EDITOR_MINIMUM_CHARACTERS") && (n = iPreferenceStore.getInt("EDITOR_MINIMUM_CHARACTERS")) >= 0) {
            defaultTabFolder.setMinimumCharacters(n);
        }
        PresentablePartFolder presentablePartFolder = new PresentablePartFolder(defaultTabFolder);
        TabbedStackPresentation tabbedStackPresentation = new TabbedStackPresentation(iStackPresentationSite, presentablePartFolder, (ISystemMenu)new StandardEditorSystemMenu(iStackPresentationSite));
        DefaultThemeListener defaultThemeListener = new DefaultThemeListener(defaultTabFolder, tabbedStackPresentation.getTheme());
        tabbedStackPresentation.getTheme().addListener(defaultThemeListener);
        new DefaultMultiTabListener(tabbedStackPresentation.getApiPreferences(), "SHOW_MULTIPLE_EDITOR_TABS", defaultTabFolder);
        new DefaultSimpleTabListener(tabbedStackPresentation.getApiPreferences(), "SHOW_TRADITIONAL_STYLE_TABS", defaultTabFolder);
        return tabbedStackPresentation;
    }

    @Override
    public StackPresentation createViewPresentation(Composite composite, IStackPresentationSite iStackPresentationSite) {
        DefaultTabFolder defaultTabFolder = new DefaultTabFolder(composite, viewTabPosition | 0x800, iStackPresentationSite.supportsState(0), iStackPresentationSite.supportsState(1));
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        int n = iPreferenceStore.getInt("VIEW_MINIMUM_CHARACTERS");
        if (n >= 0) {
            defaultTabFolder.setMinimumCharacters(n);
        }
        PresentablePartFolder presentablePartFolder = new PresentablePartFolder(defaultTabFolder);
        defaultTabFolder.setUnselectedCloseVisible(false);
        defaultTabFolder.setUnselectedImageVisible(true);
        TabbedStackPresentation tabbedStackPresentation = new TabbedStackPresentation(iStackPresentationSite, presentablePartFolder, (ISystemMenu)new StandardViewSystemMenu(iStackPresentationSite));
        DefaultThemeListener defaultThemeListener = new DefaultThemeListener(defaultTabFolder, tabbedStackPresentation.getTheme());
        tabbedStackPresentation.getTheme().addListener(defaultThemeListener);
        new DefaultSimpleTabListener(tabbedStackPresentation.getApiPreferences(), "SHOW_TRADITIONAL_STYLE_TABS", defaultTabFolder);
        return tabbedStackPresentation;
    }

    @Override
    public StackPresentation createStandaloneViewPresentation(Composite composite, IStackPresentationSite iStackPresentationSite, boolean bl) {
        if (bl) {
            return this.createViewPresentation(composite, iStackPresentationSite);
        }
        EmptyTabFolder emptyTabFolder = new EmptyTabFolder(composite, true);
        TabbedStackPresentation tabbedStackPresentation = new TabbedStackPresentation(iStackPresentationSite, emptyTabFolder, (ISystemMenu)new StandardViewSystemMenu(iStackPresentationSite));
        return tabbedStackPresentation;
    }
}

