/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.presentations;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IPresentationSerializer;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;

public abstract class StackPresentation
implements ISizeProvider {
    public static final int AS_INACTIVE = 0;
    public static final int AS_ACTIVE_FOCUS = 1;
    public static final int AS_ACTIVE_NOFOCUS = 2;
    private IStackPresentationSite site;

    protected StackPresentation(IStackPresentationSite iStackPresentationSite) {
        Assert.isNotNull((Object)iStackPresentationSite);
        this.site = iStackPresentationSite;
    }

    protected IStackPresentationSite getSite() {
        return this.site;
    }

    public abstract void setBounds(Rectangle var1);

    public Point computeMinimumSize() {
        return new Point(0, 0);
    }

    @Override
    public int getSizeFlags(boolean bl) {
        boolean bl2 = this.getSite().getState() == 0;
        return 0x80 | (bl2 ? 1024 : 0);
    }

    @Override
    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        int n4 = Geometry.getCoordinate((Point)this.computeMinimumSize(), (boolean)bl);
        if (this.getSite().getState() == 0 || n3 < n4) {
            return n4;
        }
        return n3;
    }

    public abstract void dispose();

    public abstract void setActive(int var1);

    public abstract void setVisible(boolean var1);

    public abstract void setState(int var1);

    public abstract Control getControl();

    public abstract void addPart(IPresentablePart var1, Object var2);

    public abstract void removePart(IPresentablePart var1);

    public void movePart(IPresentablePart iPresentablePart, Object object) {
        this.removePart(iPresentablePart);
        this.addPart(iPresentablePart, object);
        if (this.getSite().getSelectedPart() == iPresentablePart) {
            this.selectPart(iPresentablePart);
            iPresentablePart.setFocus();
        }
    }

    public abstract void selectPart(IPresentablePart var1);

    public abstract StackDropResult dragOver(Control var1, Point var2);

    public abstract void showSystemMenu();

    public abstract void showPaneMenu();

    public void showPartList() {
    }

    public void saveState(IPresentationSerializer iPresentationSerializer, IMemento iMemento) {
    }

    public void restoreState(IPresentationSerializer iPresentationSerializer, IMemento iMemento) {
    }

    public abstract Control[] getTabList(IPresentablePart var1);
}

