/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class WizardPropertyPage
extends PropertyPage {
    private IWizard fWizard;
    private Composite fWizardPageContainer;

    public IWizard getWizard() {
        return this.fWizard;
    }

    protected abstract IWizard createWizard();

    protected abstract void applyChanges();

    protected Control createContents(Composite composite) {
        this.fWizardPageContainer = new Composite(composite, 0);
        this.fWizardPageContainer.setFont(composite.getFont());
        this.fWizardPageContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fWizardPageContainer.setLayout((Layout)gridLayout);
        this.createWizardPageContent(this.fWizardPageContainer);
        return this.fWizardPageContainer;
    }

    private void createWizardPageContent(Composite composite) {
        this.fWizard = this.createWizard();
        if (this.fWizard == null) {
            return;
        }
        this.fWizard.addPages();
        PropertyPageWizardContainer propertyPageWizardContainer = new PropertyPageWizardContainer(this, this.fWizard);
        propertyPageWizardContainer.updateButtons();
        propertyPageWizardContainer.updateMessage();
        this.fWizard.setContainer((IWizardContainer)propertyPageWizardContainer);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setFont(composite2.getFont());
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fWizard.createPageControls(composite);
        IWizardPage iWizardPage = this.fWizard.getPages()[0];
        if (iWizardPage.getControl() == null) {
            iWizardPage.createControl(composite);
        }
        Control control = iWizardPage.getControl();
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setPageName(iWizardPage);
        this.setDescription(iWizardPage, label);
        iWizardPage.setVisible(true);
        this.setValid(this.fWizard.canFinish());
    }

    private void setPageName(IWizardPage iWizardPage) {
        String string = iWizardPage.getTitle();
        if (string == null) {
            string = iWizardPage.getName();
        }
        this.setMessage(string);
    }

    private void setDescription(IWizardPage iWizardPage, Label label) {
        IMessageProvider iMessageProvider;
        String string = null;
        if (iWizardPage.getDescription() != null) {
            string = iWizardPage.getDescription();
        } else if (iWizardPage instanceof IMessageProvider && (iMessageProvider = (IMessageProvider)iWizardPage).getMessageType() == 0) {
            string = iMessageProvider.getMessage();
        }
        if (string != null) {
            label.setText(string);
        } else {
            label.setVisible(false);
        }
    }

    public boolean performOk() {
        this.fWizard.performFinish();
        this.applyChanges();
        this.fWizard.dispose();
        return super.performOk();
    }

    public boolean performCancel() {
        this.fWizard.performCancel();
        this.fWizard.dispose();
        return super.performCancel();
    }

    protected void performApply() {
        this.fWizard.performFinish();
        this.applyChanges();
        this.fWizard.dispose();
        this.rebuildWizardPage();
        super.performApply();
    }

    protected void performDefaults() {
        this.fWizard.performCancel();
        this.fWizard.dispose();
        this.rebuildWizardPage();
        super.performDefaults();
    }

    private void rebuildWizardPage() {
        Control[] controlArray = this.fWizardPageContainer.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].dispose();
            ++n;
        }
        this.createWizardPageContent(this.fWizardPageContainer);
        this.fWizardPageContainer.getParent().layout(true, true);
    }

    private static final class PropertyPageWizardContainer
    implements IWizardContainer {
        private final IWizard fWizard;
        private final PropertyPage fPage;
        private String fMessage;

        private PropertyPageWizardContainer(PropertyPage propertyPage, IWizard iWizard) {
            Assert.isLegal((iWizard.getPageCount() == 1 ? 1 : 0) != 0);
            this.fPage = propertyPage;
            this.fWizard = iWizard;
        }

        public IWizardPage getCurrentPage() {
            return this.fWizard.getPages()[0];
        }

        public Shell getShell() {
            return this.fPage.getShell();
        }

        public void showPage(IWizardPage iWizardPage) {
        }

        public void updateButtons() {
            this.fPage.setValid(this.fWizard.canFinish());
        }

        public void updateMessage() {
            IWizardPage iWizardPage = this.getCurrentPage();
            String string = this.fPage.getMessage();
            if (string != null && this.fMessage == null) {
                this.fMessage = string;
            }
            if (iWizardPage.getErrorMessage() != null) {
                this.fPage.setMessage(iWizardPage.getErrorMessage(), 3);
            } else if (iWizardPage instanceof IMessageProvider) {
                IMessageProvider iMessageProvider = (IMessageProvider)iWizardPage;
                if (iMessageProvider.getMessageType() != 0) {
                    this.fPage.setMessage(iMessageProvider.getMessage(), iMessageProvider.getMessageType());
                } else {
                    if (iMessageProvider.getMessage() != null && this.fMessage == null) {
                        this.fMessage = iMessageProvider.getMessage();
                    }
                    this.fPage.setMessage(this.fMessage, 0);
                }
            } else {
                this.fPage.setErrorMessage(null);
            }
        }

        public void updateTitleBar() {
            IWizardPage iWizardPage = this.getCurrentPage();
            String string = iWizardPage.getTitle();
            if (string == null) {
                string = iWizardPage.getName();
            }
            this.fPage.setMessage(string);
        }

        public void updateWindowTitle() {
        }

        public void run(boolean bl, boolean bl2, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(bl, bl2, iRunnableWithProgress);
        }
    }
}

