/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.preferences;

import java.io.IOException;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ScopedPreferenceStore
extends EventManager
implements IPreferenceStore,
IPersistentPreferenceStore {
    private IScopeContext storeContext;
    private IScopeContext[] searchContexts;
    protected boolean silentRunning = false;
    IEclipsePreferences.IPreferenceChangeListener preferencesListener;
    private IScopeContext defaultContext = new DefaultScope();
    String nodeQualifier;
    String defaultQualifier;
    private boolean dirty;

    public ScopedPreferenceStore(IScopeContext iScopeContext, String string, String string2) {
        this(iScopeContext, string);
        this.defaultQualifier = string2;
    }

    public ScopedPreferenceStore(IScopeContext iScopeContext, String string) {
        this.storeContext = iScopeContext;
        this.nodeQualifier = string;
        this.defaultQualifier = string;
        ((IEclipsePreferences)this.getStorePreferences().parent()).addNodeChangeListener(this.getNodeChangeListener());
    }

    private IEclipsePreferences.INodeChangeListener getNodeChangeListener() {
        return new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
                if (ScopedPreferenceStore.this.nodeQualifier.equals(nodeChangeEvent.getChild().name()) && ScopedPreferenceStore.this.isListenerAttached()) {
                    ScopedPreferenceStore.this.getStorePreferences().addPreferenceChangeListener(ScopedPreferenceStore.this.preferencesListener);
                }
            }

            public void removed(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
            }
        };
    }

    private void initializePreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
                    if (ScopedPreferenceStore.this.silentRunning) {
                        return;
                    }
                    Object object = preferenceChangeEvent.getOldValue();
                    Object object2 = preferenceChangeEvent.getNewValue();
                    String string = preferenceChangeEvent.getKey();
                    if (object2 == null) {
                        object2 = ScopedPreferenceStore.this.getDefault(string, object);
                    } else if (object == null) {
                        object = ScopedPreferenceStore.this.getDefault(string, object2);
                    }
                    ScopedPreferenceStore.this.firePropertyChangeEvent(preferenceChangeEvent.getKey(), object, object2);
                }
            };
            this.getStorePreferences().addPreferenceChangeListener(this.preferencesListener);
        }
    }

    Object getDefault(String string, Object object) {
        IEclipsePreferences iEclipsePreferences = this.getDefaultPreferences();
        if (object instanceof String) {
            return iEclipsePreferences.get(string, "");
        }
        if (object instanceof Integer) {
            return new Integer(iEclipsePreferences.getInt(string, 0));
        }
        if (object instanceof Double) {
            return new Double(iEclipsePreferences.getDouble(string, 0.0));
        }
        if (object instanceof Float) {
            return new Float(iEclipsePreferences.getFloat(string, 0.0f));
        }
        if (object instanceof Long) {
            return new Long(iEclipsePreferences.getLong(string, 0L));
        }
        if (object instanceof Boolean) {
            return iEclipsePreferences.getBoolean(string, false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    IEclipsePreferences getStorePreferences() {
        return this.storeContext.getNode(this.nodeQualifier);
    }

    private IEclipsePreferences getDefaultPreferences() {
        return this.defaultContext.getNode(this.defaultQualifier);
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.initializePreferencesListener();
        this.addListenerObject(iPropertyChangeListener);
    }

    public IEclipsePreferences[] getPreferenceNodes(boolean bl) {
        if (this.searchContexts == null) {
            if (bl) {
                return new IEclipsePreferences[]{this.getStorePreferences(), this.getDefaultPreferences()};
            }
            return new IEclipsePreferences[]{this.getStorePreferences()};
        }
        int n = this.searchContexts.length;
        if (bl) {
            ++n;
        }
        IEclipsePreferences[] iEclipsePreferencesArray = new IEclipsePreferences[n];
        int n2 = 0;
        while (n2 < this.searchContexts.length) {
            iEclipsePreferencesArray[n2] = this.searchContexts[n2].getNode(this.nodeQualifier);
            ++n2;
        }
        if (bl) {
            iEclipsePreferencesArray[n - 1] = this.getDefaultPreferences();
        }
        return iEclipsePreferencesArray;
    }

    public void setSearchContexts(IScopeContext[] iScopeContextArray) {
        this.searchContexts = iScopeContextArray;
        if (iScopeContextArray == null) {
            return;
        }
        int n = 0;
        while (n < iScopeContextArray.length) {
            if (iScopeContextArray[n].equals(this.defaultContext)) {
                Assert.isTrue((boolean)false, (String)WorkbenchMessages.ScopedPreferenceStore_DefaultAddedError);
            }
            ++n;
        }
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        return Platform.getPreferencesService().get(string, null, (Preferences[])this.getPreferenceNodes(true)) != null;
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        Object[] objectArray = this.getListeners();
        if (objectArray.length == 0) {
            return;
        }
        final PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        int n = 0;
        while (n < objectArray.length) {
            final IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(JFaceResources.getString((String)"PreferenceStore.changeError")){

                public void run() {
                    iPropertyChangeListener.propertyChange(propertyChangeEvent);
                }
            });
            ++n;
        }
    }

    public boolean getBoolean(String string) {
        String string2 = this.internalGet(string);
        return string2 == null ? false : Boolean.valueOf(string2);
    }

    public boolean getDefaultBoolean(String string) {
        return this.getDefaultPreferences().getBoolean(string, false);
    }

    public double getDefaultDouble(String string) {
        return this.getDefaultPreferences().getDouble(string, 0.0);
    }

    public float getDefaultFloat(String string) {
        return this.getDefaultPreferences().getFloat(string, 0.0f);
    }

    public int getDefaultInt(String string) {
        return this.getDefaultPreferences().getInt(string, 0);
    }

    public long getDefaultLong(String string) {
        return this.getDefaultPreferences().getLong(string, 0L);
    }

    public String getDefaultString(String string) {
        return this.getDefaultPreferences().get(string, "");
    }

    public double getDouble(String string) {
        String string2 = this.internalGet(string);
        if (string2 == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    private String internalGet(String string) {
        return Platform.getPreferencesService().get(string, null, (Preferences[])this.getPreferenceNodes(true));
    }

    public float getFloat(String string) {
        String string2 = this.internalGet(string);
        if (string2 == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public int getInt(String string) {
        String string2 = this.internalGet(string);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public long getLong(String string) {
        String string2 = this.internalGet(string);
        if (string2 == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public String getString(String string) {
        String string2 = this.internalGet(string);
        return string2 == null ? "" : string2;
    }

    public boolean isDefault(String string) {
        if (string == null) {
            return false;
        }
        return Platform.getPreferencesService().get(string, null, (Preferences[])this.getPreferenceNodes(false)) == null;
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public void putValue(String string, String string2) {
        try {
            this.silentRunning = true;
            this.getStorePreferences().put(string, string2);
        }
        finally {
            this.silentRunning = false;
            this.dirty = true;
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.removeListenerObject(iPropertyChangeListener);
        if (!this.isListenerAttached()) {
            this.disposePreferenceStoreListener();
        }
    }

    public void setDefault(String string, double d) {
        this.getDefaultPreferences().putDouble(string, d);
    }

    public void setDefault(String string, float f) {
        this.getDefaultPreferences().putFloat(string, f);
    }

    public void setDefault(String string, int n) {
        this.getDefaultPreferences().putInt(string, n);
    }

    public void setDefault(String string, long l) {
        this.getDefaultPreferences().putLong(string, l);
    }

    public void setDefault(String string, String string2) {
        this.getDefaultPreferences().put(string, string2);
    }

    public void setDefault(String string, boolean bl) {
        this.getDefaultPreferences().putBoolean(string, bl);
    }

    public void setToDefault(String string) {
        String string2 = this.getString(string);
        String string3 = this.getDefaultString(string);
        try {
            this.silentRunning = true;
            this.getStorePreferences().remove(string);
            if (string2 != string3) {
                this.dirty = true;
                this.firePropertyChangeEvent(string, string2, string3);
            }
        }
        finally {
            this.silentRunning = false;
        }
    }

    public void setValue(String string, double d) {
        double d2 = this.getDouble(string);
        if (d2 == d) {
            return;
        }
        try {
            this.silentRunning = true;
            if (this.getDefaultDouble(string) == d) {
                this.getStorePreferences().remove(string);
            } else {
                this.getStorePreferences().putDouble(string, d);
            }
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Double(d2), new Double(d));
        }
        finally {
            this.silentRunning = false;
        }
    }

    public void setValue(String string, float f) {
        float f2 = this.getFloat(string);
        if (f2 == f) {
            return;
        }
        try {
            this.silentRunning = true;
            if (this.getDefaultFloat(string) == f) {
                this.getStorePreferences().remove(string);
            } else {
                this.getStorePreferences().putFloat(string, f);
            }
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Float(f2), new Float(f));
        }
        finally {
            this.silentRunning = false;
        }
    }

    public void setValue(String string, int n) {
        int n2 = this.getInt(string);
        if (n2 == n) {
            return;
        }
        try {
            this.silentRunning = true;
            if (this.getDefaultInt(string) == n) {
                this.getStorePreferences().remove(string);
            } else {
                this.getStorePreferences().putInt(string, n);
            }
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Integer(n2), new Integer(n));
        }
        finally {
            this.silentRunning = false;
        }
    }

    public void setValue(String string, long l) {
        long l2 = this.getLong(string);
        if (l2 == l) {
            return;
        }
        try {
            this.silentRunning = true;
            if (this.getDefaultLong(string) == l) {
                this.getStorePreferences().remove(string);
            } else {
                this.getStorePreferences().putLong(string, l);
            }
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Long(l2), new Long(l));
        }
        finally {
            this.silentRunning = false;
        }
    }

    public void setValue(String string, String string2) {
        if (this.getDefaultString(string).equals(string2)) {
            this.getStorePreferences().remove(string);
        } else {
            this.getStorePreferences().put(string, string2);
        }
        this.dirty = true;
    }

    public void setValue(String string, boolean bl) {
        boolean bl2 = this.getBoolean(string);
        if (bl2 == bl) {
            return;
        }
        try {
            this.silentRunning = true;
            if (this.getDefaultBoolean(string) == bl) {
                this.getStorePreferences().remove(string);
            } else {
                this.getStorePreferences().putBoolean(string, bl);
            }
            this.dirty = true;
            this.firePropertyChangeEvent(string, bl2 ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
        }
        finally {
            this.silentRunning = false;
        }
    }

    public void save() throws IOException {
        try {
            this.getStorePreferences().flush();
            this.dirty = false;
        }
        catch (BackingStoreException backingStoreException) {
            throw new IOException(backingStoreException.getMessage());
        }
    }

    private void disposePreferenceStoreListener() {
        IEclipsePreferences iEclipsePreferences = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance");
        try {
            if (!iEclipsePreferences.nodeExists(this.nodeQualifier)) {
                return;
            }
        }
        catch (BackingStoreException backingStoreException) {
            return;
        }
        IEclipsePreferences iEclipsePreferences2 = this.getStorePreferences();
        if (iEclipsePreferences2 == null) {
            return;
        }
        if (this.preferencesListener != null) {
            iEclipsePreferences2.removePreferenceChangeListener(this.preferencesListener);
            this.preferencesListener = null;
        }
    }
}

