/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public abstract class AbstractUIPlugin
extends Plugin {
    private static final String FN_DIALOG_SETTINGS = "dialog_settings.xml";
    private IDialogSettings dialogSettings = null;
    private ScopedPreferenceStore preferenceStore;
    private ImageRegistry imageRegistry = null;
    private BundleListener bundleListener;

    public AbstractUIPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
    }

    public AbstractUIPlugin() {
    }

    protected ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    public IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.loadDialogSettings();
        }
        return this.dialogSettings;
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.createImageRegistry();
            this.initializeImageRegistry(this.imageRegistry);
        }
        return this.imageRegistry;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), this.getBundle().getSymbolicName());
        }
        return this.preferenceStore;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
    }

    protected void initializeDefaultPluginPreferences() {
        this.loadPreferenceStore();
        this.initializeDefaultPreferences(this.getPreferenceStore());
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
    }

    protected void loadDialogSettings() {
        block18: {
            Object object;
            Object object2;
            this.dialogSettings = new DialogSettings("Workbench");
            IPath iPath = this.getStateLocationOrNull();
            if (iPath != null && ((File)(object2 = new File((String)(object = iPath.append(FN_DIALOG_SETTINGS).toOSString())))).exists()) {
                try {
                    this.dialogSettings.load((String)object);
                }
                catch (IOException iOException) {
                    this.dialogSettings = new DialogSettings("Workbench");
                }
                return;
            }
            object = BundleUtility.find(this.getBundle(), FN_DIALOG_SETTINGS);
            if (object == null) {
                return;
            }
            object2 = null;
            try {
                try {
                    object2 = ((URL)object).openStream();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object2, "utf-8"));
                    this.dialogSettings.load((Reader)bufferedReader);
                }
                catch (IOException iOException) {
                    this.dialogSettings = new DialogSettings("Workbench");
                    try {
                        if (object2 != null) {
                            ((InputStream)object2).close();
                        }
                        break block18;
                    }
                    catch (IOException iOException2) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (object2 != null) {
                    ((InputStream)object2).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void loadPreferenceStore() {
    }

    protected void refreshPluginActions() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                WWinPluginAction.refreshActionList();
            }
        });
    }

    protected void saveDialogSettings() {
        if (this.dialogSettings == null) {
            return;
        }
        try {
            IPath iPath = this.getStateLocationOrNull();
            if (iPath == null) {
                return;
            }
            String string = iPath.append(FN_DIALOG_SETTINGS).toOSString();
            this.dialogSettings.save(string);
        }
        catch (IOException iOException) {
        }
        catch (IllegalStateException illegalStateException) {}
    }

    protected void savePreferenceStore() {
        this.savePluginPreferences();
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        final BundleContext bundleContext2 = bundleContext;
        this.bundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                if (bundleEvent.getBundle() == AbstractUIPlugin.this.getBundle() && bundleEvent.getType() == 2) {
                    if (AbstractUIPlugin.this.getBundle().getState() == 32) {
                        AbstractUIPlugin.this.refreshPluginActions();
                    }
                    bundleContext2.removeBundleListener((BundleListener)this);
                }
            }
        };
        bundleContext.addBundleListener(this.bundleListener);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            if (this.bundleListener != null) {
                bundleContext.removeBundleListener(this.bundleListener);
            }
            this.saveDialogSettings();
            this.savePreferenceStore();
            this.preferenceStore = null;
            if (this.imageRegistry != null) {
                this.imageRegistry.dispose();
            }
            this.imageRegistry = null;
        }
        finally {
            super.stop(bundleContext);
        }
    }

    public static ImageDescriptor imageDescriptorFromPlugin(String string, String string2) {
        ImageDescriptor imageDescriptor;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        IWorkbench iWorkbench = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench() : null;
        ImageDescriptor imageDescriptor2 = imageDescriptor = iWorkbench == null ? null : iWorkbench.getSharedImages().getImageDescriptor(string2);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        Bundle bundle = Platform.getBundle((String)string);
        if (!BundleUtility.isReady(bundle)) {
            return null;
        }
        URL uRL = BundleUtility.find(bundle, string2);
        if (uRL == null) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println(String.valueOf(string2) + " does not exist in plugin " + string);
                return null;
            }
        }
        return ImageDescriptor.createFromURL((URL)uRL);
    }

    private IPath getStateLocationOrNull() {
        try {
            return this.getStateLocation();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }
}

