/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import com.ibm.icu.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class WorkbenchPart
extends EventManager
implements IWorkbenchPart3,
IExecutableExtension,
IWorkbenchPartOrientation {
    private String title = "";
    private ImageDescriptor imageDescriptor;
    private Image titleImage;
    private String toolTip = "";
    private IConfigurationElement configElement;
    private IWorkbenchPartSite partSite;
    private String partName = "";
    private String contentDescription = "";
    private ListenerList partChangeListeners = new ListenerList();
    private Map partProperties = new HashMap();

    protected WorkbenchPart() {
    }

    @Override
    public void addPropertyListener(IPropertyListener iPropertyListener) {
        this.addListenerObject(iPropertyListener);
    }

    @Override
    public abstract void createPartControl(Composite var1);

    @Override
    public void dispose() {
        if (this.imageDescriptor != null) {
            JFaceResources.getResources().destroyImage(this.imageDescriptor);
        }
        this.clearListeners();
        this.partChangeListeners.clear();
    }

    protected void firePropertyChange(int n) {
        Object[] objectArray = this.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            IPropertyListener iPropertyListener = (IPropertyListener)objectArray[n2];
            try {
                iPropertyListener.propertyChanged(this, n);
            }
            catch (RuntimeException runtimeException) {
                WorkbenchPlugin.log(runtimeException);
            }
            ++n2;
        }
    }

    public Object getAdapter(Class clazz) {
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    protected Image getDefaultImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
    }

    @Override
    public IWorkbenchPartSite getSite() {
        return this.partSite;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Image getTitleImage() {
        if (this.titleImage != null) {
            return this.titleImage;
        }
        return this.getDefaultImage();
    }

    @Override
    public String getTitleToolTip() {
        return this.toolTip;
    }

    @Override
    public void removePropertyListener(IPropertyListener iPropertyListener) {
        this.removeListenerObject(iPropertyListener);
    }

    @Override
    public abstract void setFocus();

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.configElement = iConfigurationElement;
        this.title = this.partName = Util.safeString(iConfigurationElement.getAttribute("name"));
        String string2 = iConfigurationElement.getAttribute("icon");
        if (string2 == null) {
            return;
        }
        this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.configElement.getNamespace(), string2);
        if (this.imageDescriptor == null) {
            return;
        }
        this.titleImage = JFaceResources.getResources().createImageWithDefault(this.imageDescriptor);
    }

    protected void setSite(IWorkbenchPartSite iWorkbenchPartSite) {
        this.checkSite(iWorkbenchPartSite);
        this.partSite = iWorkbenchPartSite;
    }

    protected void checkSite(IWorkbenchPartSite iWorkbenchPartSite) {
    }

    protected void setTitle(String string) {
        if (Util.equals(this.title, string = Util.safeString(string))) {
            return;
        }
        this.title = string;
        this.firePropertyChange(1);
    }

    protected void setTitleImage(Image image) {
        Assert.isTrue((image == null || !image.isDisposed() ? 1 : 0) != 0);
        if (this.titleImage == image) {
            return;
        }
        this.titleImage = image;
        this.firePropertyChange(1);
        if (this.imageDescriptor != null) {
            JFaceResources.getResources().destroyImage(this.imageDescriptor);
            this.imageDescriptor = null;
        }
    }

    protected void setTitleToolTip(String string) {
        if (Util.equals(this.toolTip, string = Util.safeString(string))) {
            return;
        }
        this.toolTip = string;
        this.firePropertyChange(1);
    }

    public void showBusy(boolean bl) {
    }

    @Override
    public String getPartName() {
        return this.partName;
    }

    protected void setPartName(String string) {
        this.internalSetPartName(string);
        this.setDefaultTitle();
    }

    void setDefaultTitle() {
        String string;
        String string2 = this.getContentDescription();
        String string3 = string = this.getPartName();
        if (!Util.equals(string2, "")) {
            string3 = MessageFormat.format((String)WorkbenchMessages.WorkbenchPart_AutoTitleFormat, (Object[])new String[]{string, string2});
        }
        this.setTitle(string3);
    }

    @Override
    public String getContentDescription() {
        return this.contentDescription;
    }

    protected void setContentDescription(String string) {
        this.internalSetContentDescription(string);
        this.setDefaultTitle();
    }

    void internalSetContentDescription(String string) {
        Assert.isNotNull((Object)string);
        if (Util.equals(this.contentDescription, string)) {
            return;
        }
        this.contentDescription = string;
        this.firePropertyChange(261);
    }

    void internalSetPartName(String string) {
        string = Util.safeString(string);
        Assert.isNotNull((Object)string);
        if (Util.equals(this.partName, string)) {
            return;
        }
        this.partName = string;
        this.firePropertyChange(260);
    }

    @Override
    public int getOrientation() {
        return Window.getDefaultOrientation();
    }

    @Override
    public void addPartPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.partChangeListeners.add((Object)iPropertyChangeListener);
    }

    @Override
    public void removePartPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.partChangeListeners.remove((Object)iPropertyChangeListener);
    }

    protected void firePartPropertyChanged(String string, String string2, String string3) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, (Object)string2, (Object)string3);
        Object[] objectArray = this.partChangeListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            try {
                ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            }
            catch (RuntimeException runtimeException) {
                WorkbenchPlugin.log(runtimeException);
            }
            ++n;
        }
    }

    @Override
    public void setPartProperty(String string, String string2) {
        String string3 = (String)this.partProperties.get(string);
        if (string2 == null) {
            this.partProperties.remove(string);
        } else {
            this.partProperties.put(string, string2);
        }
        this.firePartPropertyChanged(string, string3, string2);
    }

    @Override
    public String getPartProperty(String string) {
        return (String)this.partProperties.get(string);
    }

    @Override
    public Map getPartProperties() {
        return Collections.unmodifiableMap(this.partProperties);
    }
}

