/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.WorkbenchPart;

public abstract class ViewPart
extends WorkbenchPart
implements IViewPart {
    private IPropertyListener compatibilityTitleListener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object object, int n) {
            if (n == 1) {
                ViewPart.this.setDefaultContentDescription();
            }
        }
    };

    protected ViewPart() {
        this.addPropertyListener(this.compatibilityTitleListener);
    }

    @Override
    public IViewSite getViewSite() {
        return (IViewSite)this.getSite();
    }

    @Override
    public void init(IViewSite iViewSite) throws PartInitException {
        this.setSite(iViewSite);
        this.setDefaultContentDescription();
    }

    @Override
    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        this.init(iViewSite);
    }

    @Override
    public void saveState(IMemento iMemento) {
    }

    @Override
    protected void setPartName(String string) {
        if (this.compatibilityTitleListener != null) {
            this.removePropertyListener(this.compatibilityTitleListener);
            this.compatibilityTitleListener = null;
        }
        super.setPartName(string);
    }

    @Override
    protected void setContentDescription(String string) {
        if (this.compatibilityTitleListener != null) {
            this.removePropertyListener(this.compatibilityTitleListener);
            this.compatibilityTitleListener = null;
        }
        super.setContentDescription(string);
    }

    @Override
    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        super.setInitializationData(iConfigurationElement, string, object);
        this.setDefaultContentDescription();
    }

    private void setDefaultContentDescription() {
        String string;
        if (this.compatibilityTitleListener == null) {
            return;
        }
        String string2 = this.getPartName();
        if (Util.equals(string2, string = this.getTitle())) {
            this.internalSetContentDescription("");
        } else {
            this.internalSetContentDescription(string);
        }
    }

    @Override
    protected final void checkSite(IWorkbenchPartSite iWorkbenchPartSite) {
        super.checkSite(iWorkbenchPartSite);
        Assert.isTrue((boolean)(iWorkbenchPartSite instanceof IViewSite), (String)"The site for a view must be an IViewSite");
    }
}

