/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.part.PluginTransferData;

public class PluginTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "pluggable-transfer-format";
    private static final int TYPEID = PluginTransfer.registerType((String)"pluggable-transfer-format");
    private static PluginTransfer instance = new PluginTransfer();

    private PluginTransfer() {
    }

    public static PluginTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        PluginTransferData pluginTransferData = (PluginTransferData)object;
        if (object == null) {
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(pluginTransferData.getExtensionId());
            dataOutputStream.writeInt(pluginTransferData.getData().length);
            dataOutputStream.write(pluginTransferData.getData());
            dataOutputStream.close();
            super.javaToNative((Object)byteArrayOutputStream.toByteArray(), transferData);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        try {
            byte[] byArray = (byte[])super.nativeToJava(transferData);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            String string = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            byte[] byArray2 = new byte[n];
            dataInputStream.readFully(byArray2);
            return new PluginTransferData(string, byArray2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

