/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.part.IDropActionDelegate;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class PluginDropAdapter
extends ViewerDropAdapter {
    public static final String ATT_CLASS = "class";
    private TransferData currentTransfer;

    public PluginDropAdapter(StructuredViewer structuredViewer) {
        super((Viewer)structuredViewer);
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        try {
            if (PluginTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType)) {
                PluginTransferData pluginTransferData = (PluginTransferData)dropTargetEvent.data;
                IDropActionDelegate iDropActionDelegate = PluginDropAdapter.getPluginAdapter(pluginTransferData);
                if (!iDropActionDelegate.run(pluginTransferData.getData(), this.getCurrentTarget())) {
                    dropTargetEvent.detail = 0;
                }
            } else {
                super.drop(dropTargetEvent);
            }
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Drop Failed", coreException.getStatus());
        }
    }

    protected TransferData getCurrentTransfer() {
        return this.currentTransfer;
    }

    protected static IDropActionDelegate getPluginAdapter(PluginTransferData pluginTransferData) throws CoreException {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        String string = pluginTransferData.getExtensionId();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.ui", "dropActions");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            if (iConfigurationElementArray != null && iConfigurationElementArray.length > 0) {
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    String string2 = iConfigurationElementArray[n2].getAttribute("id");
                    if (string2 != null && string2.equals(string)) {
                        return (IDropActionDelegate)WorkbenchPlugin.createExtension(iConfigurationElementArray[n2], ATT_CLASS);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    public boolean performDrop(Object object) {
        return false;
    }

    public boolean validateDrop(Object object, int n, TransferData transferData) {
        this.currentTransfer = transferData;
        return this.currentTransfer != null && PluginTransfer.getInstance().isSupportedType(this.currentTransfer);
    }
}

