/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.part.IPageSiteHolder;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IDisposable;

public class PageSite
implements IPageSite,
INestable {
    private ArrayList menuExtenders;
    private IViewSite parentSite;
    private ISelectionProvider selectionProvider;
    private final ServiceLocator serviceLocator;
    private SubActionBars subActionBars;

    public PageSite(final IViewSite iViewSite) {
        Assert.isNotNull((Object)iViewSite);
        this.parentSite = iViewSite;
        this.subActionBars = new SubActionBars(iViewSite.getActionBars(), this);
        IServiceLocatorCreator iServiceLocatorCreator = (IServiceLocatorCreator)this.parentSite.getService(IServiceLocatorCreator.class);
        this.serviceLocator = (ServiceLocator)iServiceLocatorCreator.createServiceLocator(iViewSite, null, new IDisposable(){

            @Override
            public void dispose() {
                Control control = ((PartSite)((Object)iViewSite)).getPane().getControl();
                if (control != null && !control.isDisposed()) {
                    ((PartSite)((Object)iViewSite)).getPane().doHide();
                }
            }
        });
        this.initializeDefaultServices();
    }

    private void initializeDefaultServices() {
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.part.PageSite", this.getWorkbenchWindow().getWorkbench(), this.getWorkbenchWindow(), this.parentSite, null, this, 3));
        this.serviceLocator.registerService(IPageSiteHolder.class, new IPageSiteHolder(){

            @Override
            public IPageSite getSite() {
                return PageSite.this;
            }
        });
    }

    protected void dispose() {
        if (this.menuExtenders != null) {
            HashSet<MenuManager> hashSet = new HashSet<MenuManager>(this.menuExtenders.size());
            int n = 0;
            while (n < this.menuExtenders.size()) {
                PopupMenuExtender popupMenuExtender = (PopupMenuExtender)this.menuExtenders.get(n);
                hashSet.add(popupMenuExtender.getManager());
                popupMenuExtender.dispose();
                ++n;
            }
            if (hashSet.size() > 0) {
                for (MenuManager menuManager : hashSet) {
                    menuManager.dispose();
                }
            }
            this.menuExtenders = null;
        }
        this.subActionBars.dispose();
        this.serviceLocator.dispose();
    }

    @Override
    public IActionBars getActionBars() {
        return this.subActionBars;
    }

    public Object getAdapter(Class clazz) {
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    @Override
    public IWorkbenchPage getPage() {
        return this.parentSite.getPage();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    @Override
    public final Object getService(Class clazz) {
        return this.serviceLocator.getService(clazz);
    }

    @Override
    public Shell getShell() {
        return this.parentSite.getShell();
    }

    @Override
    public IWorkbenchWindow getWorkbenchWindow() {
        return this.parentSite.getWorkbenchWindow();
    }

    @Override
    public final boolean hasService(Class clazz) {
        return this.serviceLocator.hasService(clazz);
    }

    @Override
    public void registerContextMenu(String string, MenuManager menuManager, ISelectionProvider iSelectionProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(string, menuManager, iSelectionProvider, false, this.parentSite.getPart(), this.menuExtenders);
    }

    @Override
    public void setSelectionProvider(ISelectionProvider iSelectionProvider) {
        this.selectionProvider = iSelectionProvider;
    }

    @Override
    public void activate() {
        this.serviceLocator.activate();
    }

    @Override
    public void deactivate() {
        this.serviceLocator.deactivate();
    }
}

