/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.part.ViewPart;

public abstract class PageBookView
extends ViewPart
implements IPartListener {
    private PageBook book;
    private PageRec defaultPageRec;
    private Map mapPartToRec = new HashMap();
    private Map mapPageToSite = new HashMap();
    private Map mapPageToNumRecs = new HashMap();
    private PageRec activeRec;
    private IWorkbenchPart hiddenPart = null;
    private IPropertyChangeListener actionBarPropListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals("org.eclipse.ui.internal.actionHandlers") && PageBookView.this.activeRec != null && propertyChangeEvent.getSource() == ((PageBookView)PageBookView.this).activeRec.subActionBars) {
                PageBookView.this.refreshGlobalActionHandlers();
            }
        }
    };
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            PageBookView.this.pageSelectionChanged(selectionChangedEvent);
        }
    };
    private ISelectionChangedListener postSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            PageBookView.this.postSelectionChanged(selectionChangedEvent);
        }
    };
    private SelectionProvider selectionProvider = new SelectionProvider();
    private IPartListener2 partListener = new IPartListener2(){

        @Override
        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
            PageBookView.this.partActivated(iWorkbenchPart);
        }

        @Override
        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            PageBookView.this.partBroughtToTop(iWorkbenchPartReference.getPart(false));
        }

        @Override
        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            PageBookView.this.partClosed(iWorkbenchPartReference.getPart(false));
        }

        @Override
        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            PageBookView.this.partDeactivated(iWorkbenchPartReference.getPart(false));
        }

        @Override
        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            PageBookView.this.partHidden(iWorkbenchPartReference.getPart(false));
        }

        @Override
        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        @Override
        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            PageBookView.this.partOpened(iWorkbenchPartReference.getPart(false));
        }

        @Override
        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            PageBookView.this.partVisible(iWorkbenchPartReference.getPart(false));
        }
    };

    protected PageBookView() {
    }

    protected abstract IPage createDefaultPage(PageBook var1);

    private PageRec createPage(IWorkbenchPart iWorkbenchPart) {
        PageRec pageRec = this.doCreatePage(iWorkbenchPart);
        if (pageRec != null) {
            this.mapPartToRec.put(iWorkbenchPart, pageRec);
            this.preparePage(pageRec);
        }
        return pageRec;
    }

    private void preparePage(PageRec pageRec) {
        Integer n;
        IPageSite iPageSite = null;
        if (!this.doesPageExist(pageRec.page)) {
            if (pageRec.page instanceof IPageBookViewPage) {
                iPageSite = ((IPageBookViewPage)pageRec.page).getSite();
            }
            if (iPageSite == null) {
                iPageSite = new PageSite(this.getViewSite());
            }
            this.mapPageToSite.put(pageRec.page, iPageSite);
            pageRec.subActionBars = (SubActionBars)iPageSite.getActionBars();
            pageRec.subActionBars.addPropertyChangeListener(this.actionBarPropListener);
            pageRec.page.setActionBars(pageRec.subActionBars);
            n = new Integer(0);
        } else {
            iPageSite = (IPageSite)this.mapPageToSite.get(pageRec.page);
            pageRec.subActionBars = (SubActionBars)iPageSite.getActionBars();
            n = (Integer)this.mapPageToNumRecs.get(pageRec.page);
        }
        this.mapPageToNumRecs.put(pageRec.page, new Integer(n + 1));
    }

    protected void initPage(IPageBookViewPage iPageBookViewPage) {
        try {
            iPageBookViewPage.init(new PageSite(this.getViewSite()));
        }
        catch (PartInitException partInitException) {
            WorkbenchPlugin.log(this.getClass(), "initPage", (Throwable)((Object)partInitException));
        }
    }

    @Override
    public void createPartControl(Composite composite) {
        this.book = new PageBook(composite, 0);
        IPage iPage = this.createDefaultPage(this.book);
        this.defaultPageRec = new PageRec(null, iPage);
        this.preparePage(this.defaultPageRec);
        this.showPageRec(this.defaultPageRec);
        this.getSite().getPage().addPartListener(this.partListener);
        this.showBootstrapPart();
    }

    @Override
    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        this.activeRec = null;
        if (this.defaultPageRec != null) {
            this.defaultPageRec.page.dispose();
            this.defaultPageRec = null;
        }
        Map map = (Map)((HashMap)this.mapPartToRec).clone();
        for (PageRec pageRec : map.values()) {
            this.removePage(pageRec);
        }
        super.dispose();
    }

    protected abstract PageRec doCreatePage(IWorkbenchPart var1);

    protected abstract void doDestroyPage(IWorkbenchPart var1, PageRec var2);

    protected boolean doesPageExist(IPage iPage) {
        return this.mapPageToNumRecs.containsKey(iPage);
    }

    @Override
    public Object getAdapter(Class clazz) {
        IPage iPage = this.getCurrentPage();
        Object object = Util.getAdapter(iPage, clazz);
        if (object != null) {
            return object;
        }
        object = this.getViewAdapter(clazz);
        if (object != null) {
            return object;
        }
        return super.getAdapter(clazz);
    }

    protected Object getViewAdapter(Class clazz) {
        return null;
    }

    protected abstract IWorkbenchPart getBootstrapPart();

    protected IWorkbenchPart getCurrentContributingPart() {
        if (this.activeRec == null) {
            return null;
        }
        return this.activeRec.part;
    }

    public IPage getCurrentPage() {
        if (this.activeRec == null) {
            return null;
        }
        return this.activeRec.page;
    }

    protected PageSite getPageSite(IPage iPage) {
        return (PageSite)this.mapPageToSite.get(iPage);
    }

    public IPage getDefaultPage() {
        return this.defaultPageRec.page;
    }

    protected PageBook getPageBook() {
        return this.book;
    }

    protected PageRec getPageRec(IWorkbenchPart iWorkbenchPart) {
        return (PageRec)this.mapPartToRec.get(iWorkbenchPart);
    }

    protected PageRec getPageRec(IPage iPage) {
        for (PageRec pageRec : this.mapPartToRec.values()) {
            if (pageRec.page != iPage) continue;
            return pageRec;
        }
        return null;
    }

    protected abstract boolean isImportant(IWorkbenchPart var1);

    @Override
    public void init(IViewSite iViewSite) throws PartInitException {
        iViewSite.setSelectionProvider((ISelectionProvider)this.selectionProvider);
        super.init(iViewSite);
    }

    @Override
    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (!this.isImportant(iWorkbenchPart)) {
            return;
        }
        this.hiddenPart = null;
        PageRec pageRec = this.getPageRec(iWorkbenchPart);
        if (pageRec == null) {
            pageRec = this.createPage(iWorkbenchPart);
        }
        if (pageRec != null) {
            this.showPageRec(pageRec);
        } else {
            this.showPageRec(this.defaultPageRec);
        }
    }

    @Override
    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    @Override
    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        PageRec pageRec;
        if (this.activeRec != null && this.activeRec.part == iWorkbenchPart) {
            this.showPageRec(this.defaultPageRec);
        }
        if ((pageRec = this.getPageRec(iWorkbenchPart)) != null) {
            this.removePage(pageRec);
        }
        if (iWorkbenchPart == this.hiddenPart) {
            this.hiddenPart = null;
        }
    }

    @Override
    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    @Override
    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    private void refreshGlobalActionHandlers() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        iActionBars.clearGlobalActionHandlers();
        Map map = this.activeRec.subActionBars.getGlobalActionHandlers();
        if (map != null) {
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                iActionBars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
    }

    private void removePage(PageRec pageRec) {
        this.mapPartToRec.remove(pageRec.part);
        int n = (Integer)this.mapPageToNumRecs.get(pageRec.page) - 1;
        if (n == 0) {
            Object v = this.mapPageToSite.remove(pageRec.page);
            this.mapPageToNumRecs.remove(pageRec.page);
            Control control = pageRec.page.getControl();
            if (control != null && !control.isDisposed()) {
                control.dispose();
            }
            this.doDestroyPage(pageRec.part, pageRec);
            if (pageRec.subActionBars != null) {
                pageRec.subActionBars.dispose();
            }
            if (v instanceof PageSite) {
                ((PageSite)v).dispose();
            }
        } else {
            this.mapPageToNumRecs.put(pageRec.page, new Integer(n));
        }
    }

    @Override
    public void setFocus() {
        if (this.book != null) {
            this.book.setFocus();
        }
        if (this.activeRec != null) {
            this.activeRec.page.setFocus();
        }
    }

    private void pageSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        SelectionProvider selectionProvider = (SelectionProvider)this.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.selectionChanged(selectionChangedEvent);
        }
    }

    private void postSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        SelectionProvider selectionProvider = (SelectionProvider)this.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.postSelectionChanged(selectionChangedEvent);
        }
    }

    private void showBootstrapPart() {
        IWorkbenchPart iWorkbenchPart = this.getBootstrapPart();
        if (iWorkbenchPart != null) {
            this.partActivated(iWorkbenchPart);
        }
    }

    protected void showPageRec(PageRec pageRec) {
        Object object;
        PageSite pageSite;
        if (this.activeRec == pageRec) {
            return;
        }
        if (this.activeRec != null && pageRec != null && this.activeRec.page == pageRec.page) {
            this.activeRec = pageRec;
            return;
        }
        if (this.activeRec != null) {
            pageSite = (PageSite)this.mapPageToSite.get(this.activeRec.page);
            this.activeRec.subActionBars.deactivate();
            pageSite.deactivate();
            object = pageSite.getSelectionProvider();
            if (object != null) {
                object.removeSelectionChangedListener(this.selectionChangedListener);
                if (object instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)object).removePostSelectionChangedListener(this.postSelectionListener);
                } else {
                    object.removeSelectionChangedListener(this.postSelectionListener);
                }
            }
        }
        this.activeRec = pageRec;
        pageSite = this.activeRec.page.getControl();
        if (pageSite != null && !pageSite.isDisposed()) {
            object = (PageSite)this.mapPageToSite.get(this.activeRec.page);
            this.book.showPage((Control)pageSite);
            this.activeRec.subActionBars.activate();
            this.refreshGlobalActionHandlers();
            ((PageSite)object).activate();
            ISelectionProvider iSelectionProvider = ((PageSite)object).getSelectionProvider();
            if (iSelectionProvider != null) {
                iSelectionProvider.addSelectionChangedListener(this.selectionChangedListener);
                if (iSelectionProvider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)iSelectionProvider).addPostSelectionChangedListener(this.postSelectionListener);
                } else {
                    iSelectionProvider.addSelectionChangedListener(this.postSelectionListener);
                }
            }
            this.getViewSite().getActionBars().updateActionBars();
        }
    }

    protected SelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    protected void partHidden(IWorkbenchPart iWorkbenchPart) {
        IViewPart[] iViewPartArray;
        if (iWorkbenchPart == null || iWorkbenchPart != this.getCurrentContributingPart()) {
            return;
        }
        if (this.getSite().getPage().getPartState(this.getSite().getPage().getReference(iWorkbenchPart)) == 0) {
            return;
        }
        if (iWorkbenchPart instanceof IViewPart && this.containsPart(iViewPartArray = this.getSite().getPage().getViewStack(this), iWorkbenchPart)) {
            return;
        }
        this.hiddenPart = iWorkbenchPart;
        this.showPageRec(this.defaultPageRec);
    }

    private boolean containsPart(IViewPart[] iViewPartArray, IWorkbenchPart iWorkbenchPart) {
        if (iViewPartArray == null) {
            return false;
        }
        int n = 0;
        while (n < iViewPartArray.length) {
            if (iViewPartArray[n] == iWorkbenchPart) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void partVisible(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == null || iWorkbenchPart != this.hiddenPart) {
            return;
        }
        this.partActivated(iWorkbenchPart);
    }

    protected static class PageRec {
        public IWorkbenchPart part;
        public IPage page;
        public SubActionBars subActionBars;

        public PageRec(IWorkbenchPart iWorkbenchPart, IPage iPage) {
            this.part = iWorkbenchPart;
            this.page = iPage;
        }

        public void dispose() {
            this.part = null;
            this.page = null;
        }
    }

    private static class SelectionManager
    extends EventManager {
        private SelectionManager() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
            this.addListenerObject(iSelectionChangedListener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
            this.removeListenerObject(iSelectionChangedListener);
        }

        public void selectionChanged(final SelectionChangedEvent selectionChangedEvent) {
            Object[] objectArray = this.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                final ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        iSelectionChangedListener.selectionChanged(selectionChangedEvent);
                    }
                });
                ++n;
            }
        }
    }

    protected class SelectionProvider
    implements IPostSelectionProvider {
        private SelectionManager fSelectionListener = new SelectionManager();
        private SelectionManager fPostSelectionListeners = new SelectionManager();

        protected SelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
            this.fSelectionListener.addSelectionChangedListener(iSelectionChangedListener);
        }

        public ISelection getSelection() {
            IPage iPage = PageBookView.this.getCurrentPage();
            if (iPage == null) {
                return StructuredSelection.EMPTY;
            }
            PageSite pageSite = PageBookView.this.getPageSite(iPage);
            if (pageSite == null) {
                return StructuredSelection.EMPTY;
            }
            ISelectionProvider iSelectionProvider = pageSite.getSelectionProvider();
            if (iSelectionProvider != null) {
                return iSelectionProvider.getSelection();
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
            this.fSelectionListener.removeSelectionChangedListener(iSelectionChangedListener);
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            this.fSelectionListener.selectionChanged(selectionChangedEvent);
        }

        public void postSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
            this.fPostSelectionListeners.selectionChanged(selectionChangedEvent);
        }

        public void setSelection(ISelection iSelection) {
            IPage iPage = PageBookView.this.getCurrentPage();
            if (iPage == null) {
                return;
            }
            PageSite pageSite = PageBookView.this.getPageSite(iPage);
            if (pageSite == null) {
                return;
            }
            ISelectionProvider iSelectionProvider = pageSite.getSelectionProvider();
            if (iSelectionProvider != null) {
                iSelectionProvider.setSelection(iSelection);
            }
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
            this.fPostSelectionListeners.addSelectionChangedListener(iSelectionChangedListener);
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
            this.fPostSelectionListeners.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }
}

