/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MultiPageSelectionProvider
implements IPostSelectionProvider {
    private ListenerList listeners = new ListenerList();
    private ListenerList postListeners = new ListenerList();
    private MultiPageEditorPart multiPageEditor;

    public MultiPageSelectionProvider(MultiPageEditorPart multiPageEditorPart) {
        Assert.isNotNull((Object)multiPageEditorPart);
        this.multiPageEditor = multiPageEditorPart;
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.add((Object)iSelectionChangedListener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.postListeners.add((Object)iSelectionChangedListener);
    }

    public void fireSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Object[] objectArray = this.listeners.getListeners();
        this.fireEventChange(selectionChangedEvent, objectArray);
    }

    public void firePostSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Object[] objectArray = this.postListeners.getListeners();
        this.fireEventChange(selectionChangedEvent, objectArray);
    }

    private void fireEventChange(final SelectionChangedEvent selectionChangedEvent, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            final ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iSelectionChangedListener.selectionChanged(selectionChangedEvent);
                }
            });
            ++n;
        }
    }

    public MultiPageEditorPart getMultiPageEditor() {
        return this.multiPageEditor;
    }

    public ISelection getSelection() {
        ISelectionProvider iSelectionProvider;
        IEditorPart iEditorPart = this.multiPageEditor.getActiveEditor();
        if (iEditorPart != null && (iSelectionProvider = iEditorPart.getSite().getSelectionProvider()) != null) {
            return iSelectionProvider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove((Object)iSelectionChangedListener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.postListeners.remove((Object)iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        ISelectionProvider iSelectionProvider;
        IEditorPart iEditorPart = this.multiPageEditor.getActiveEditor();
        if (iEditorPart != null && (iSelectionProvider = iEditorPart.getSite().getSelectionProvider()) != null) {
            iSelectionProvider.setSelection(iSelection);
        }
    }
}

