/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.part.IMultiPageEditorSiteHolder;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.services.IDisposable;

public class MultiPageEditorSite
implements IEditorSite,
INestable {
    private IEditorPart editor;
    private ArrayList menuExtenders;
    private MultiPageEditorPart multiPageEditor;
    private ISelectionChangedListener postSelectionChangedListener = null;
    private ISelectionChangedListener selectionChangedListener = null;
    private ISelectionProvider selectionProvider = null;
    private IKeyBindingService service = null;
    private final ServiceLocator serviceLocator;

    public MultiPageEditorSite(MultiPageEditorPart multiPageEditorPart, IEditorPart iEditorPart) {
        Assert.isNotNull((Object)multiPageEditorPart);
        Assert.isNotNull((Object)iEditorPart);
        this.multiPageEditor = multiPageEditorPart;
        this.editor = iEditorPart;
        IWorkbenchPartSite iWorkbenchPartSite = multiPageEditorPart.getSite();
        IServiceLocatorCreator iServiceLocatorCreator = (IServiceLocatorCreator)iWorkbenchPartSite.getService(IServiceLocatorCreator.class);
        this.serviceLocator = (ServiceLocator)iServiceLocatorCreator.createServiceLocator(multiPageEditorPart.getSite(), null, new IDisposable(){

            @Override
            public void dispose() {
                Control control = ((PartSite)MultiPageEditorSite.this.getMultiPageEditor().getSite()).getPane().getControl();
                if (control != null && !control.isDisposed()) {
                    ((PartSite)MultiPageEditorSite.this.getMultiPageEditor().getSite()).getPane().doHide();
                }
            }
        });
        this.initializeDefaultServices();
    }

    private void initializeDefaultServices() {
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.part.MultiPageEditorSite", this.getWorkbenchWindow().getWorkbench(), this.getWorkbenchWindow(), this.getMultiPageEditor().getSite(), this, null, 3));
        this.serviceLocator.registerService(IMultiPageEditorSiteHolder.class, new IMultiPageEditorSiteHolder(){

            @Override
            public MultiPageEditorSite getSite() {
                return MultiPageEditorSite.this;
            }
        });
    }

    @Override
    public final void activate() {
        this.serviceLocator.activate();
    }

    @Override
    public final void deactivate() {
        this.serviceLocator.deactivate();
    }

    public void dispose() {
        if (this.menuExtenders != null) {
            int n = 0;
            while (n < this.menuExtenders.size()) {
                ((PopupMenuExtender)this.menuExtenders.get(n)).dispose();
                ++n;
            }
            this.menuExtenders = null;
        }
        if (this.service != null) {
            IKeyBindingService iKeyBindingService = this.getMultiPageEditor().getEditorSite().getKeyBindingService();
            if (iKeyBindingService instanceof INestableKeyBindingService) {
                INestableKeyBindingService iNestableKeyBindingService = (INestableKeyBindingService)iKeyBindingService;
                iNestableKeyBindingService.removeKeyBindingService(this);
            }
            if (this.service instanceof KeyBindingService) {
                ((KeyBindingService)this.service).dispose();
            }
            this.service = null;
        }
        if (this.serviceLocator != null) {
            this.serviceLocator.dispose();
        }
    }

    @Override
    public IEditorActionBarContributor getActionBarContributor() {
        return null;
    }

    @Override
    public IActionBars getActionBars() {
        return this.multiPageEditor.getEditorSite().getActionBars();
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public ILabelDecorator getDecoratorManager() {
        return this.getWorkbenchWindow().getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    @Override
    public String getId() {
        return "";
    }

    @Override
    public IKeyBindingService getKeyBindingService() {
        if (this.service == null) {
            this.service = this.getMultiPageEditor().getEditorSite().getKeyBindingService();
            if (this.service instanceof INestableKeyBindingService) {
                INestableKeyBindingService iNestableKeyBindingService = (INestableKeyBindingService)this.service;
                this.service = iNestableKeyBindingService.getKeyBindingService(this);
            } else {
                WorkbenchPlugin.log("MultiPageEditorSite.getKeyBindingService()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + this.service.getClass().getName() + " instead.");
            }
        }
        return this.service;
    }

    public MultiPageEditorPart getMultiPageEditor() {
        return this.multiPageEditor;
    }

    @Override
    public IWorkbenchPage getPage() {
        return this.getMultiPageEditor().getSite().getPage();
    }

    @Override
    public IWorkbenchPart getPart() {
        return this.editor;
    }

    @Override
    public String getPluginId() {
        return "";
    }

    private ISelectionChangedListener getPostSelectionChangedListener() {
        if (this.postSelectionChangedListener == null) {
            this.postSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    MultiPageEditorSite.this.handlePostSelectionChanged(selectionChangedEvent);
                }
            };
        }
        return this.postSelectionChangedListener;
    }

    @Override
    public String getRegisteredName() {
        return "";
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    MultiPageEditorSite.this.handleSelectionChanged(selectionChangedEvent);
                }
            };
        }
        return this.selectionChangedListener;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    @Override
    public final Object getService(Class clazz) {
        return this.serviceLocator.getService(clazz);
    }

    @Override
    public Shell getShell() {
        return this.getMultiPageEditor().getSite().getShell();
    }

    @Override
    public IWorkbenchWindow getWorkbenchWindow() {
        return this.getMultiPageEditor().getSite().getWorkbenchWindow();
    }

    protected void handlePostSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelectionProvider iSelectionProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
        if (iSelectionProvider instanceof MultiPageSelectionProvider) {
            SelectionChangedEvent selectionChangedEvent2 = new SelectionChangedEvent(iSelectionProvider, selectionChangedEvent.getSelection());
            MultiPageSelectionProvider multiPageSelectionProvider = (MultiPageSelectionProvider)iSelectionProvider;
            multiPageSelectionProvider.firePostSelectionChanged(selectionChangedEvent2);
        }
    }

    protected void handleSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelectionProvider iSelectionProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
        if (iSelectionProvider instanceof MultiPageSelectionProvider) {
            SelectionChangedEvent selectionChangedEvent2 = new SelectionChangedEvent(iSelectionProvider, selectionChangedEvent.getSelection());
            MultiPageSelectionProvider multiPageSelectionProvider = (MultiPageSelectionProvider)iSelectionProvider;
            multiPageSelectionProvider.fireSelectionChanged(selectionChangedEvent2);
        }
    }

    @Override
    public final boolean hasService(Class clazz) {
        return this.serviceLocator.hasService(clazz);
    }

    @Override
    public void registerContextMenu(MenuManager menuManager, ISelectionProvider iSelectionProvider) {
        this.getMultiPageEditor().getSite().registerContextMenu(menuManager, iSelectionProvider);
    }

    @Override
    public final void registerContextMenu(MenuManager menuManager, ISelectionProvider iSelectionProvider, boolean bl) {
        this.registerContextMenu(this.getId(), menuManager, iSelectionProvider, bl);
    }

    @Override
    public void registerContextMenu(String string, MenuManager menuManager, ISelectionProvider iSelectionProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(string, menuManager, iSelectionProvider, true, this.editor, this.menuExtenders);
    }

    @Override
    public final void registerContextMenu(String string, MenuManager menuManager, ISelectionProvider iSelectionProvider, boolean bl) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(string, menuManager, iSelectionProvider, bl, this.editor, this.menuExtenders);
    }

    @Override
    public void setSelectionProvider(ISelectionProvider iSelectionProvider) {
        ISelectionProvider iSelectionProvider2 = this.selectionProvider;
        this.selectionProvider = iSelectionProvider;
        if (iSelectionProvider2 != null) {
            iSelectionProvider2.removeSelectionChangedListener(this.getSelectionChangedListener());
            if (iSelectionProvider2 instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)iSelectionProvider2).removePostSelectionChangedListener(this.getPostSelectionChangedListener());
            } else {
                iSelectionProvider2.removeSelectionChangedListener(this.getPostSelectionChangedListener());
            }
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
            if (this.selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.selectionProvider).addPostSelectionChangedListener(this.getPostSelectionChangedListener());
            } else {
                this.selectionProvider.addSelectionChangedListener(this.getPostSelectionChangedListener());
            }
        }
    }
}

