/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.part.PageSwitcher;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public abstract class MultiPageEditorPart
extends EditorPart
implements IPageChangeProvider {
    private static final String COMMAND_NEXT_SUB_TAB = "org.eclipse.ui.navigate.nextSubTab";
    private static final String COMMAND_PREVIOUS_SUB_TAB = "org.eclipse.ui.navigate.previousSubTab";
    protected static final int PAGE_CONTAINER_SITE = 65535;
    private static final String TRACING_COMPONENT = "MPE";
    private INestable activeServiceLocator;
    private CTabFolder container;
    private ArrayList nestedEditors = new ArrayList(3);
    private List pageSites = new ArrayList(3);
    private IServiceLocator pageContainerSite;
    private ListenerList pageChangeListeners = new ListenerList(1);

    protected MultiPageEditorPart() {
    }

    public int addPage(Control control) {
        int n = this.getPageCount();
        this.addPage(n, control);
        return n;
    }

    public void addPage(int n, Control control) {
        this.createItem(n, control);
    }

    public int addPage(IEditorPart iEditorPart, IEditorInput iEditorInput) throws PartInitException {
        int n = this.getPageCount();
        this.addPage(n, iEditorPart, iEditorInput);
        return n;
    }

    public void addPage(int n, IEditorPart iEditorPart, IEditorInput iEditorInput) throws PartInitException {
        IEditorSite iEditorSite = this.createSite(iEditorPart);
        iEditorPart.init(iEditorSite, iEditorInput);
        Composite composite = new Composite(this.getContainer(), this.getOrientation(iEditorPart));
        composite.setLayout((Layout)new FillLayout());
        iEditorPart.createPartControl(composite);
        iEditorPart.addPropertyListener(new IPropertyListener(){

            @Override
            public void propertyChanged(Object object, int n) {
                MultiPageEditorPart.this.handlePropertyChange(n);
            }
        });
        CTabItem cTabItem = this.createItem(n, (Control)composite);
        cTabItem.setData((Object)iEditorPart);
        this.nestedEditors.add(iEditorPart);
    }

    private int getOrientation(IEditorPart iEditorPart) {
        if (iEditorPart instanceof IWorkbenchPartOrientation) {
            return ((IWorkbenchPartOrientation)((Object)iEditorPart)).getOrientation();
        }
        return this.getOrientation();
    }

    private CTabFolder createContainer(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        final CTabFolder cTabFolder = new CTabFolder(composite, 0x800400);
        cTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = cTabFolder.indexOf((CTabItem)selectionEvent.item);
                MultiPageEditorPart.this.pageChange(n);
            }
        });
        cTabFolder.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                switch (traverseEvent.detail) {
                    case 256: 
                    case 512: {
                        int n = traverseEvent.detail;
                        traverseEvent.doit = true;
                        traverseEvent.detail = 0;
                        Composite composite = cTabFolder.getParent();
                        composite.traverse(n, new Event());
                    }
                }
            }
        });
        return cTabFolder;
    }

    private CTabItem createItem(int n, Control control) {
        CTabItem cTabItem = new CTabItem(this.getTabFolder(), 0, n);
        cTabItem.setControl(control);
        return cTabItem;
    }

    protected abstract void createPages();

    @Override
    public final void createPartControl(Composite composite) {
        Composite composite2 = this.createPageContainer(composite);
        this.container = this.createContainer(composite2);
        this.createPages();
        if (this.getActivePage() == -1) {
            IEditorSite iEditorSite;
            this.setActivePage(0);
            IEditorPart iEditorPart = this.getEditor(0);
            if (iEditorPart != null && (iEditorSite = iEditorPart.getEditorSite()) instanceof INestable) {
                this.activeServiceLocator = (INestable)((Object)iEditorSite);
                this.activeServiceLocator.activate();
            }
        }
        this.initializePageSwitching();
        this.initializeSubTabSwitching();
    }

    protected void initializePageSwitching() {
        new PageSwitcher(this){

            @Override
            public Object[] getPages() {
                int n = MultiPageEditorPart.this.getPageCount();
                Object[] objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = new Integer(n2);
                    ++n2;
                }
                return objectArray;
            }

            @Override
            public String getName(Object object) {
                return MultiPageEditorPart.this.getPageText((Integer)object);
            }

            @Override
            public ImageDescriptor getImageDescriptor(Object object) {
                Image image = MultiPageEditorPart.this.getPageImage((Integer)object);
                if (image == null) {
                    return null;
                }
                return ImageDescriptor.createFromImage((Image)image);
            }

            @Override
            public void activatePage(Object object) {
                MultiPageEditorPart.this.setActivePage((Integer)object);
            }

            @Override
            public int getCurrentPageIndex() {
                return MultiPageEditorPart.this.getActivePage();
            }
        };
    }

    private void initializeSubTabSwitching() {
        IHandlerService iHandlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        iHandlerService.activateHandler(COMMAND_NEXT_SUB_TAB, (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
                int n = MultiPageEditorPart.this.getPageCount();
                if (n == 0) {
                    return null;
                }
                int n2 = MultiPageEditorPart.this.getActivePage() + 1;
                if (n2 >= n) {
                    n2 = 0;
                }
                MultiPageEditorPart.this.setActivePage(n2);
                return null;
            }
        });
        iHandlerService.activateHandler(COMMAND_PREVIOUS_SUB_TAB, (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
                int n = MultiPageEditorPart.this.getPageCount();
                if (n == 0) {
                    return null;
                }
                int n2 = MultiPageEditorPart.this.getActivePage() - 1;
                if (n2 < 0) {
                    n2 = n - 1;
                }
                MultiPageEditorPart.this.setActivePage(n2);
                return null;
            }
        });
    }

    protected Composite createPageContainer(Composite composite) {
        return composite;
    }

    protected IEditorSite createSite(IEditorPart iEditorPart) {
        return new MultiPageEditorSite(this, iEditorPart);
    }

    @Override
    public void dispose() {
        Object object;
        this.pageChangeListeners.clear();
        int n = 0;
        while (n < this.nestedEditors.size()) {
            object = (IEditorPart)this.nestedEditors.get(n);
            this.disposePart((IWorkbenchPart)object);
            ++n;
        }
        this.nestedEditors.clear();
        if (this.pageContainerSite instanceof IDisposable) {
            ((IDisposable)((Object)this.pageContainerSite)).dispose();
            this.pageContainerSite = null;
        }
        n = 0;
        while (n < this.pageSites.size()) {
            object = (IServiceLocator)this.pageSites.get(n);
            if (object instanceof IDisposable) {
                ((IDisposable)object).dispose();
            }
            ++n;
        }
        this.pageSites.clear();
        super.dispose();
    }

    protected IEditorPart getActiveEditor() {
        int n = this.getActivePage();
        if (n != -1) {
            return this.getEditor(n);
        }
        return null;
    }

    public int getActivePage() {
        CTabFolder cTabFolder = this.getTabFolder();
        if (cTabFolder != null && !cTabFolder.isDisposed()) {
            return cTabFolder.getSelectionIndex();
        }
        return -1;
    }

    protected Composite getContainer() {
        return this.container;
    }

    protected Control getControl(int n) {
        return this.getItem(n).getControl();
    }

    protected IEditorPart getEditor(int n) {
        Object object;
        CTabItem cTabItem = this.getItem(n);
        if (cTabItem != null && (object = cTabItem.getData()) instanceof IEditorPart) {
            return (IEditorPart)object;
        }
        return null;
    }

    protected final IServiceLocator getPageSite(int n) {
        if (n == 65535) {
            return this.getPageContainerSite();
        }
        CTabItem cTabItem = this.getItem(n);
        if (cTabItem != null) {
            Object object = cTabItem.getData();
            if (object instanceof IEditorPart) {
                return ((IEditorPart)object).getSite();
            }
            if (object instanceof IServiceLocator) {
                return (IServiceLocator)object;
            }
            if (object == null) {
                IServiceLocatorCreator iServiceLocatorCreator = (IServiceLocatorCreator)this.getSite().getService(IServiceLocatorCreator.class);
                IServiceLocator iServiceLocator = iServiceLocatorCreator.createServiceLocator(this.getSite(), null, new IDisposable(){

                    @Override
                    public void dispose() {
                        Control control = ((PartSite)MultiPageEditorPart.this.getSite()).getPane().getControl();
                        if (control != null && !control.isDisposed()) {
                            ((PartSite)MultiPageEditorPart.this.getSite()).getPane().doHide();
                        }
                    }
                });
                cTabItem.setData((Object)iServiceLocator);
                this.pageSites.add(iServiceLocator);
                return iServiceLocator;
            }
        }
        return null;
    }

    private IServiceLocator getPageContainerSite() {
        if (this.pageContainerSite == null) {
            IServiceLocatorCreator iServiceLocatorCreator = (IServiceLocatorCreator)this.getSite().getService(IServiceLocatorCreator.class);
            this.pageContainerSite = iServiceLocatorCreator.createServiceLocator(this.getSite(), null, new IDisposable(){

                @Override
                public void dispose() {
                    Control control = ((PartSite)MultiPageEditorPart.this.getSite()).getPane().getControl();
                    if (control != null && !control.isDisposed()) {
                        ((PartSite)MultiPageEditorPart.this.getSite()).getPane().doHide();
                    }
                }
            });
        }
        return this.pageContainerSite;
    }

    private CTabItem getItem(int n) {
        return this.getTabFolder().getItem(n);
    }

    protected int getPageCount() {
        CTabFolder cTabFolder = this.getTabFolder();
        if (cTabFolder != null && !cTabFolder.isDisposed()) {
            return cTabFolder.getItemCount();
        }
        return 0;
    }

    protected Image getPageImage(int n) {
        return this.getItem(n).getImage();
    }

    protected String getPageText(int n) {
        return this.getItem(n).getText();
    }

    private CTabFolder getTabFolder() {
        return this.container;
    }

    protected void handlePropertyChange(int n) {
        this.firePropertyChange(n);
    }

    @Override
    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite(iEditorSite);
        this.setInput(iEditorInput);
        iEditorSite.setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider(this));
    }

    @Override
    public boolean isDirty() {
        for (IEditorPart iEditorPart : this.nestedEditors) {
            if (!iEditorPart.isDirty()) continue;
            return true;
        }
        return false;
    }

    protected void pageChange(int n) {
        Object object;
        this.deactivateSite(false, false);
        IPartService iPartService = (IPartService)this.getSite().getService(IPartService.class);
        if (iPartService.getActivePart() == this) {
            this.setFocus();
        }
        IEditorPart iEditorPart = this.getEditor(n);
        IEditorActionBarContributor iEditorActionBarContributor = this.getEditorSite().getActionBarContributor();
        if (iEditorActionBarContributor != null && iEditorActionBarContributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)iEditorActionBarContributor).setActivePage(iEditorPart);
        }
        if (iEditorPart != null && (object = iEditorPart.getSite().getSelectionProvider()) != null) {
            ISelectionProvider iSelectionProvider = this.getSite().getSelectionProvider();
            if (iSelectionProvider instanceof MultiPageSelectionProvider) {
                SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent(object, object.getSelection());
                MultiPageSelectionProvider multiPageSelectionProvider = (MultiPageSelectionProvider)iSelectionProvider;
                multiPageSelectionProvider.fireSelectionChanged(selectionChangedEvent);
                multiPageSelectionProvider.firePostSelectionChanged(selectionChangedEvent);
            } else if (Policy.DEBUG_MPE) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("MultiPageEditorPart " + this.getTitle() + " did not propogate selection for " + iEditorPart.getTitle()));
            }
        }
        this.activateSite();
        object = this.getSelectedPage();
        if (object != null) {
            this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, object));
        }
    }

    protected final void deactivateSite(boolean bl, boolean bl2) {
        Object object;
        if (this.activeServiceLocator != null) {
            this.activeServiceLocator.deactivate();
            this.activeServiceLocator = null;
        }
        int n = this.getActivePage();
        IKeyBindingService iKeyBindingService = this.getSite().getKeyBindingService();
        if (n < 0 || n >= this.getPageCount() || bl) {
            if (iKeyBindingService instanceof INestableKeyBindingService) {
                object = (INestableKeyBindingService)iKeyBindingService;
                object.activateKeyBindingService(null);
            } else {
                WorkbenchPlugin.log("MultiPageEditorPart.deactivateSite()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + iKeyBindingService.getClass().getName() + " instead.");
            }
        }
        if (bl2 && (object = this.getPageContainerSite()) instanceof INestable) {
            this.activeServiceLocator = (INestable)object;
            this.activeServiceLocator.activate();
        }
    }

    protected final void activateSite() {
        if (this.activeServiceLocator != null) {
            this.activeServiceLocator.deactivate();
            this.activeServiceLocator = null;
        }
        IKeyBindingService iKeyBindingService = this.getSite().getKeyBindingService();
        int n = this.getActivePage();
        IEditorPart iEditorPart = this.getEditor(n);
        if (iEditorPart != null) {
            Object object;
            if (iKeyBindingService instanceof INestableKeyBindingService) {
                object = (INestableKeyBindingService)iKeyBindingService;
                object.activateKeyBindingService(iEditorPart.getEditorSite());
            } else {
                WorkbenchPlugin.log("MultiPageEditorPart.activateSite()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + iKeyBindingService.getClass().getName() + " instead.");
            }
            object = iEditorPart.getEditorSite();
            if (object instanceof INestable) {
                this.activeServiceLocator = (INestable)object;
                this.activeServiceLocator.activate();
            }
        } else {
            CTabItem cTabItem = this.getItem(n);
            if (iKeyBindingService instanceof INestableKeyBindingService) {
                INestableKeyBindingService iNestableKeyBindingService = (INestableKeyBindingService)iKeyBindingService;
                iNestableKeyBindingService.activateKeyBindingService(null);
            } else {
                WorkbenchPlugin.log("MultiPageEditorPart.activateSite()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + iKeyBindingService.getClass().getName() + " instead.");
            }
            if (cTabItem.getData() instanceof INestable) {
                this.activeServiceLocator = (INestable)cTabItem.getData();
                this.activeServiceLocator.activate();
            }
        }
    }

    private void disposePart(final IWorkbenchPart iWorkbenchPart) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchPart.getSite();
                iWorkbenchPart.dispose();
                if (iWorkbenchPartSite instanceof MultiPageEditorSite) {
                    ((MultiPageEditorSite)iWorkbenchPartSite).dispose();
                }
            }

            public void handleException(Throwable throwable) {
            }
        });
    }

    public void removePage(int n) {
        Assert.isTrue((n >= 0 && n < this.getPageCount() ? 1 : 0) != 0);
        IEditorPart iEditorPart = this.getEditor(n);
        CTabItem cTabItem = this.getItem(n);
        IServiceLocator iServiceLocator = null;
        if (cTabItem.getData() instanceof IServiceLocator) {
            iServiceLocator = (IServiceLocator)cTabItem.getData();
        }
        Control control = cTabItem.getControl();
        cTabItem.dispose();
        if (control != null) {
            control.dispose();
        }
        if (iEditorPart != null) {
            this.nestedEditors.remove(iEditorPart);
            this.disposePart(iEditorPart);
        }
        if (iServiceLocator != null) {
            this.pageSites.remove(iServiceLocator);
            if (iServiceLocator instanceof IDisposable) {
                ((IDisposable)((Object)iServiceLocator)).dispose();
            }
        }
    }

    protected void setActivePage(int n) {
        Assert.isTrue((n >= 0 && n < this.getPageCount() ? 1 : 0) != 0);
        this.getTabFolder().setSelection(n);
        this.pageChange(n);
    }

    protected void setControl(int n, Control control) {
        this.getItem(n).setControl(control);
    }

    @Override
    public void setFocus() {
        this.setFocus(this.getActivePage());
    }

    private void setFocus(int n) {
        if (n < 0 || n >= this.getPageCount()) {
            return;
        }
        IEditorPart iEditorPart = this.getEditor(n);
        if (iEditorPart != null) {
            iEditorPart.setFocus();
        } else {
            Control control = this.getControl(n);
            if (control != null) {
                control.setFocus();
            }
        }
    }

    protected void setPageImage(int n, Image image) {
        this.getItem(n).setImage(image);
    }

    protected void setPageText(int n, String string) {
        this.getItem(n).setText(string);
    }

    @Override
    public Object getAdapter(Class clazz) {
        IEditorPart iEditorPart;
        Object object = super.getAdapter(clazz);
        if (object == null && Display.getCurrent() != null && (iEditorPart = this.getActiveEditor()) != null && iEditorPart != this) {
            object = Util.getAdapter(iEditorPart, clazz);
        }
        return object;
    }

    public final IEditorPart[] findEditors(IEditorInput iEditorInput) {
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>();
        int n = this.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            IEditorPart iEditorPart = this.getEditor(n2);
            if (iEditorPart != null && iEditorPart.getEditorInput() != null && iEditorPart.getEditorInput().equals(iEditorInput)) {
                arrayList.add(iEditorPart);
            }
            ++n2;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }

    public final void setActiveEditor(IEditorPart iEditorPart) {
        int n = this.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            IEditorPart iEditorPart2 = this.getEditor(n2);
            if (iEditorPart2 == iEditorPart) {
                this.setActivePage(n2);
                break;
            }
            ++n2;
        }
    }

    public Object getSelectedPage() {
        int n = this.getActivePage();
        if (n == -1) {
            return null;
        }
        IEditorPart iEditorPart = this.getEditor(n);
        if (iEditorPart != null) {
            return iEditorPart;
        }
        return this.getControl(n);
    }

    public void addPageChangedListener(IPageChangedListener iPageChangedListener) {
        this.pageChangeListeners.add((Object)iPageChangedListener);
    }

    public void removePageChangedListener(IPageChangedListener iPageChangedListener) {
        this.pageChangeListeners.remove((Object)iPageChangedListener);
    }

    private void firePageChanged(final PageChangedEvent pageChangedEvent) {
        Object[] objectArray = this.pageChangeListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPageChangedListener iPageChangedListener = (IPageChangedListener)objectArray[n];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iPageChangedListener.pageChanged(pageChangedEvent);
                }
            });
            ++n;
        }
    }
}

