/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.AbstractMultiEditor;
import org.eclipse.ui.themes.ITheme;

public abstract class MultiEditor
extends AbstractMultiEditor {
    public void updateGradient(IEditorPart iEditorPart) {
        boolean bl = iEditorPart == this.getSite().getPage().getActiveEditor();
        boolean bl2 = iEditorPart == this.getSite().getPage().getActivePart();
        ITheme iTheme = iEditorPart.getEditorSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme();
        Gradient gradient = new Gradient();
        ColorRegistry colorRegistry = iTheme.getColorRegistry();
        if (bl2) {
            gradient.fgColor = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR");
            gradient.bgColors = new Color[2];
            gradient.bgColors[0] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
            gradient.bgColors[1] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        } else if (bl) {
            gradient.fgColor = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR");
            gradient.bgColors = new Color[2];
            gradient.bgColors[0] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
            gradient.bgColors[1] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        } else {
            gradient.fgColor = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR");
            gradient.bgColors = new Color[2];
            gradient.bgColors[0] = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START");
            gradient.bgColors[1] = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END");
        }
        gradient.bgPercents = new int[]{iTheme.getInt("org.eclipse.ui.workbench.ACTIVE_TAB_PERCENT")};
        this.drawGradient(iEditorPart, gradient);
    }

    protected abstract void drawGradient(IEditorPart var1, Gradient var2);

    public Composite createInnerPartControl(Composite composite, final IEditorPart iEditorPart) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        iEditorPart.createPartControl(composite2);
        composite.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    MultiEditor.this.activateEditor(iEditorPart);
                }
            }
        });
        return composite2;
    }

    @Override
    public void setFocus() {
        super.setFocus();
        this.updateGradient(this.getActiveEditor());
    }

    @Override
    public void activateEditor(IEditorPart iEditorPart) {
        IEditorPart iEditorPart2 = this.getActiveEditor();
        super.activateEditor(iEditorPart);
        this.updateGradient(iEditorPart2);
    }

    protected boolean getShellActivated() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getSite().getPage().getWorkbenchWindow();
        return workbenchWindow.getShellActivated();
    }

    @Override
    public Composite getInnerEditorContainer(IEditorReference iEditorReference) {
        return null;
    }

    @Override
    protected void innerEditorsCreated() {
    }

    public static class Gradient {
        public Color fgColor;
        public Color[] bgColors;
        public int[] bgPercents;
    }
}

