/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.IntroMessages;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class IntroPart
extends EventManager
implements IIntroPart,
IExecutableExtension {
    private IConfigurationElement configElement;
    private ImageDescriptor imageDescriptor;
    private IIntroSite partSite;
    private Image titleImage;
    private String titleLabel;

    protected IntroPart() {
    }

    @Override
    public void addPropertyListener(IPropertyListener iPropertyListener) {
        this.addListenerObject(iPropertyListener);
    }

    @Override
    public abstract void createPartControl(Composite var1);

    @Override
    public void dispose() {
        if (this.titleImage != null) {
            JFaceResources.getResources().destroyImage(this.imageDescriptor);
            this.titleImage = null;
        }
        this.clearListeners();
    }

    protected void firePropertyChange(final int n) {
        Object[] objectArray = this.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            final IPropertyListener iPropertyListener = (IPropertyListener)objectArray[n2];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iPropertyListener.propertyChanged((Object)this, n);
                }
            });
            ++n2;
        }
    }

    public Object getAdapter(Class clazz) {
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    protected Image getDefaultImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
    }

    @Override
    public final IIntroSite getIntroSite() {
        return this.partSite;
    }

    @Override
    public Image getTitleImage() {
        if (this.titleImage != null) {
            return this.titleImage;
        }
        return this.getDefaultImage();
    }

    @Override
    public String getTitle() {
        if (this.titleLabel != null) {
            return this.titleLabel;
        }
        return this.getDefaultTitle();
    }

    private String getDefaultTitle() {
        return IntroMessages.Intro_default_title;
    }

    @Override
    public void init(IIntroSite iIntroSite, IMemento iMemento) throws PartInitException {
        this.setSite(iIntroSite);
    }

    protected void setSite(IIntroSite iIntroSite) {
        this.partSite = iIntroSite;
    }

    @Override
    public void removePropertyListener(IPropertyListener iPropertyListener) {
        this.removeListenerObject(iPropertyListener);
    }

    @Override
    public void saveState(IMemento iMemento) {
    }

    @Override
    public abstract void setFocus();

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        Image image;
        this.configElement = iConfigurationElement;
        this.titleLabel = iConfigurationElement.getAttribute("label");
        String string2 = iConfigurationElement.getAttribute("icon");
        if (string2 == null) {
            return;
        }
        this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.configElement.getNamespace(), string2);
        if (this.imageDescriptor == null) {
            return;
        }
        this.titleImage = image = JFaceResources.getResources().createImageWithDefault(this.imageDescriptor);
    }

    protected void setTitleImage(Image image) {
        Assert.isTrue((image == null || !image.isDisposed() ? 1 : 0) != 0);
        if (this.titleImage == image) {
            return;
        }
        this.titleImage = image;
        this.firePropertyChange(1);
    }

    protected void setTitle(String string) {
        Assert.isNotNull((Object)string);
        if (Util.equals(this.titleLabel, string)) {
            return;
        }
        this.titleLabel = string;
        this.firePropertyChange(1);
    }
}

