/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.WorkbenchPart;

public abstract class EditorPart
extends WorkbenchPart
implements IEditorPart {
    private IEditorInput editorInput = null;
    private IPropertyListener compatibilityTitleListener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object object, int n) {
            if (n == 1) {
                EditorPart.this.setDefaultPartName();
            }
        }
    };

    protected EditorPart() {
        this.addPropertyListener(this.compatibilityTitleListener);
    }

    @Override
    public abstract void doSave(IProgressMonitor var1);

    @Override
    public abstract void doSaveAs();

    @Override
    public IEditorInput getEditorInput() {
        return this.editorInput;
    }

    @Override
    public IEditorSite getEditorSite() {
        return (IEditorSite)this.getSite();
    }

    @Override
    public String getTitleToolTip() {
        if (this.editorInput == null) {
            return super.getTitleToolTip();
        }
        return this.editorInput.getToolTipText();
    }

    @Override
    public abstract void init(IEditorSite var1, IEditorInput var2) throws PartInitException;

    @Override
    public abstract boolean isDirty();

    @Override
    public abstract boolean isSaveAsAllowed();

    @Override
    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    protected void setInput(IEditorInput iEditorInput) {
        Assert.isLegal((iEditorInput != null ? 1 : 0) != 0);
        this.editorInput = iEditorInput;
    }

    protected void setInputWithNotify(IEditorInput iEditorInput) {
        Assert.isLegal((iEditorInput != null ? 1 : 0) != 0);
        this.editorInput = iEditorInput;
        this.firePropertyChange(258);
    }

    @Override
    protected void setContentDescription(String string) {
        if (this.compatibilityTitleListener != null) {
            this.removePropertyListener(this.compatibilityTitleListener);
            this.compatibilityTitleListener = null;
        }
        super.setContentDescription(string);
    }

    @Override
    protected void setPartName(String string) {
        if (this.compatibilityTitleListener != null) {
            this.removePropertyListener(this.compatibilityTitleListener);
            this.compatibilityTitleListener = null;
        }
        super.setPartName(string);
    }

    @Override
    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        super.setInitializationData(iConfigurationElement, string, object);
        this.setDefaultPartName();
    }

    private void setDefaultPartName() {
        if (this.compatibilityTitleListener == null) {
            return;
        }
        this.internalSetPartName(this.getTitle());
    }

    @Override
    void setDefaultTitle() {
        this.setTitle(this.getPartName());
    }

    @Override
    protected final void checkSite(IWorkbenchPartSite iWorkbenchPartSite) {
        super.checkSite(iWorkbenchPartSite);
        Assert.isTrue((boolean)(iWorkbenchPartSite instanceof IEditorSite), (String)"The site for an editor must be an IEditorSite");
    }
}

