/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class EditorInputTransfer
extends ByteArrayTransfer {
    private static final EditorInputTransfer instance = new EditorInputTransfer();
    private static final String TYPE_NAME = "editor-input-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = EditorInputTransfer.registerType((String)TYPE_NAME);

    private EditorInputTransfer() {
    }

    public static EditorInputTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!(object instanceof EditorInputData[])) {
            return;
        }
        EditorInputData[] editorInputDataArray = (EditorInputData[])object;
        int n = editorInputDataArray.length;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < editorInputDataArray.length) {
                this.writeEditorInput(dataOutputStream, editorInputDataArray[n2]);
                ++n2;
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            super.javaToNative((Object)byArray, transferData);
        }
        catch (IOException iOException) {}
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] byArray = (byte[])super.nativeToJava(transferData);
        if (byArray == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            int n = dataInputStream.readInt();
            EditorInputData[] editorInputDataArray = new EditorInputData[n];
            int n2 = 0;
            while (n2 < n) {
                editorInputDataArray[n2] = this.readEditorInput(dataInputStream);
                ++n2;
            }
            return editorInputDataArray;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (WorkbenchException workbenchException) {
            return null;
        }
    }

    private EditorInputData readEditorInput(DataInputStream dataInputStream) throws IOException, WorkbenchException {
        IAdaptable iAdaptable;
        String string = dataInputStream.readUTF();
        String string2 = dataInputStream.readUTF();
        String string3 = dataInputStream.readUTF();
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        StringReader stringReader = new StringReader(string3);
        XMLMemento xMLMemento = XMLMemento.createReadRoot(stringReader);
        IElementFactory iElementFactory = PlatformUI.getWorkbench().getElementFactory(string2);
        if (iElementFactory != null && (iAdaptable = iElementFactory.createElement(xMLMemento)) != null && iAdaptable instanceof IEditorInput) {
            return new EditorInputData(string, (IEditorInput)iAdaptable);
        }
        return null;
    }

    private void writeEditorInput(DataOutputStream dataOutputStream, EditorInputData editorInputData) throws IOException {
        dataOutputStream.writeUTF(editorInputData.editorId);
        if (editorInputData.input != null) {
            XMLMemento xMLMemento = XMLMemento.createWriteRoot("IEditorInput");
            IPersistableElement iPersistableElement = editorInputData.input.getPersistable();
            if (iPersistableElement != null) {
                iPersistableElement.saveState(xMLMemento);
                StringWriter stringWriter = new StringWriter();
                xMLMemento.save(stringWriter);
                stringWriter.close();
                dataOutputStream.writeUTF(iPersistableElement.getFactoryId());
                dataOutputStream.writeUTF(stringWriter.toString());
            }
        }
    }

    public static EditorInputData createEditorInputData(String string, IEditorInput iEditorInput) {
        return new EditorInputData(string, iEditorInput);
    }

    public static class EditorInputData {
        public String editorId;
        public IEditorInput input;

        private EditorInputData(String string, IEditorInput iEditorInput) {
            this.editorId = string;
            this.input = iEditorInput;
        }
    }
}

