/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.DrillFrame;
import org.eclipse.ui.part.DrillStack;

public class DrillDownAdapter
implements ISelectionChangedListener {
    private TreeViewer fChildTree;
    private DrillStack fDrillStack = new DrillStack();
    private Action homeAction;
    private Action backAction;
    private Action forwardAction;

    public DrillDownAdapter(TreeViewer treeViewer) {
        this.fChildTree = treeViewer;
    }

    public void addNavigationActions(IMenuManager iMenuManager) {
        this.createActions();
        iMenuManager.add((IAction)this.homeAction);
        iMenuManager.add((IAction)this.backAction);
        iMenuManager.add((IAction)this.forwardAction);
        this.updateNavigationButtons();
    }

    public void addNavigationActions(IToolBarManager iToolBarManager) {
        this.createActions();
        iToolBarManager.add((IAction)this.homeAction);
        iToolBarManager.add((IAction)this.backAction);
        iToolBarManager.add((IAction)this.forwardAction);
        this.updateNavigationButtons();
    }

    public boolean canExpand(Object object) {
        return this.fChildTree.isExpandable(object);
    }

    public boolean canGoBack() {
        return this.fDrillStack.canGoBack();
    }

    public boolean canGoHome() {
        return this.fDrillStack.canGoHome();
    }

    public boolean canGoInto() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fChildTree.getSelection();
        if (iStructuredSelection == null || iStructuredSelection.size() != 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        return this.canExpand(object);
    }

    private void createActions() {
        if (this.homeAction != null) {
            return;
        }
        this.homeAction = new Action(WorkbenchMessages.GoHome_text){

            public void run() {
                DrillDownAdapter.this.goHome();
            }
        };
        this.homeAction.setToolTipText(WorkbenchMessages.GoHome_toolTip);
        this.homeAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_HOME_NAV"));
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.backAction = new Action(WorkbenchMessages.GoBack_text){

            public void run() {
                DrillDownAdapter.this.goBack();
            }
        };
        this.backAction.setToolTipText(WorkbenchMessages.GoBack_toolTip);
        this.backAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_BACK"));
        this.backAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        this.forwardAction = new Action(WorkbenchMessages.GoInto_text){

            public void run() {
                DrillDownAdapter.this.goInto();
            }
        };
        this.forwardAction.setToolTipText(WorkbenchMessages.GoInto_toolTip);
        this.forwardAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_FORWARD"));
        this.forwardAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        this.fChildTree.addSelectionChangedListener((ISelectionChangedListener)this);
        this.updateNavigationButtons();
    }

    private void expand(List list) {
        this.fChildTree.setExpandedElements(list.toArray());
    }

    private List getExpanded() {
        return Arrays.asList(this.fChildTree.getExpandedElements());
    }

    public void goBack() {
        Object object = this.fChildTree.getInput();
        DrillFrame drillFrame = this.fDrillStack.goBack();
        Object object2 = drillFrame.getElement();
        this.fChildTree.setInput(object2);
        this.expand(drillFrame.getExpansion());
        if (this.fChildTree.getSelection().isEmpty()) {
            this.fChildTree.setSelection((ISelection)new StructuredSelection(object), true);
        }
        this.updateNavigationButtons();
    }

    public void goHome() {
        Object object = this.fChildTree.getInput();
        DrillFrame drillFrame = this.fDrillStack.goHome();
        Object object2 = drillFrame.getElement();
        this.fChildTree.setInput(object2);
        this.expand(drillFrame.getExpansion());
        if (this.fChildTree.getSelection().isEmpty()) {
            this.fChildTree.setSelection((ISelection)new StructuredSelection(object), true);
        }
        this.updateNavigationButtons();
    }

    public void goInto() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fChildTree.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        this.goInto(object);
    }

    public void goInto(Object object) {
        if (this.canExpand(object)) {
            Object object2 = this.fChildTree.getInput();
            List list = this.getExpanded();
            this.fDrillStack.add(new DrillFrame(object2, "null", list));
            this.fChildTree.setInput(object);
            this.expand(list);
            this.updateNavigationButtons();
        }
    }

    public void reset() {
        this.fDrillStack.reset();
        this.updateNavigationButtons();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.updateNavigationButtons();
    }

    protected void updateNavigationButtons() {
        if (this.homeAction != null) {
            this.homeAction.setEnabled(this.canGoHome());
            this.backAction.setEnabled(this.canGoBack());
            this.forwardAction.setEnabled(this.canGoInto());
        }
    }
}

