/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.PartService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiEditorInput;

public abstract class AbstractMultiEditor
extends EditorPart {
    private int activeEditorIndex;
    private IEditorPart[] innerEditors;
    private IPartListener2 propagationListener;

    protected void handlePropertyChange(int n) {
        this.firePropertyChange(n);
    }

    @Override
    public void doSave(IProgressMonitor iProgressMonitor) {
        int n = 0;
        while (n < this.innerEditors.length) {
            IEditorPart iEditorPart = this.innerEditors[n];
            iEditorPart.doSave(iProgressMonitor);
            ++n;
        }
    }

    @Override
    public void doSaveAs() {
    }

    @Override
    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.init(iEditorSite, (MultiEditorInput)iEditorInput);
    }

    public void init(IEditorSite iEditorSite, MultiEditorInput multiEditorInput) throws PartInitException {
        this.setInput(multiEditorInput);
        this.setSite(iEditorSite);
        this.setPartName(multiEditorInput.getName());
        this.setTitleToolTip(multiEditorInput.getToolTipText());
        this.setupEvents();
    }

    @Override
    public boolean isDirty() {
        int n = 0;
        while (n < this.innerEditors.length) {
            IEditorPart iEditorPart = this.innerEditors[n];
            if (iEditorPart.isDirty()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void setFocus() {
        this.innerEditors[this.activeEditorIndex].setFocus();
    }

    public final IEditorPart getActiveEditor() {
        return this.innerEditors[this.activeEditorIndex];
    }

    public final IEditorPart[] getInnerEditors() {
        return this.innerEditors;
    }

    public final void setChildren(IEditorPart[] iEditorPartArray) {
        this.innerEditors = iEditorPartArray;
        this.activeEditorIndex = 0;
        int n = 0;
        while (n < iEditorPartArray.length) {
            iEditorPartArray[n].addPropertyListener(new IPropertyListener(){

                @Override
                public void propertyChanged(Object object, int n) {
                    AbstractMultiEditor.this.handlePropertyChange(n);
                }
            });
            ++n;
        }
        this.innerEditorsCreated();
    }

    protected abstract void innerEditorsCreated();

    public void activateEditor(IEditorPart iEditorPart) {
        this.activeEditorIndex = this.getIndex(iEditorPart);
        IEditorPart iEditorPart2 = this.getActiveEditor();
        EditorSite editorSite = (EditorSite)iEditorPart2.getEditorSite();
        ((WorkbenchPage)editorSite.getPage()).requestActivation(iEditorPart2);
    }

    protected int getIndex(IEditorPart iEditorPart) {
        int n = 0;
        while (n < this.innerEditors.length) {
            if (this.innerEditors[n] == iEditorPart) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void setupEvents() {
        this.propagationListener = new IPartListener2(){

            @Override
            public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            @Override
            public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            @Override
            public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                if (iWorkbenchPart == AbstractMultiEditor.this && AbstractMultiEditor.this.innerEditors != null) {
                    PartService partService = ((WorkbenchPage)AbstractMultiEditor.this.getSite().getPage()).getPartService();
                    int n = 0;
                    while (n < AbstractMultiEditor.this.innerEditors.length) {
                        IEditorPart iEditorPart = AbstractMultiEditor.this.innerEditors[n];
                        IWorkbenchPartReference iWorkbenchPartReference2 = ((PartSite)iEditorPart.getSite()).getPartReference();
                        partService.firePartClosed(iWorkbenchPartReference2);
                        ++n;
                    }
                }
            }

            @Override
            public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            @Override
            public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                if (iWorkbenchPart == AbstractMultiEditor.this && AbstractMultiEditor.this.innerEditors != null) {
                    PartService partService = ((WorkbenchPage)AbstractMultiEditor.this.getSite().getPage()).getPartService();
                    int n = 0;
                    while (n < AbstractMultiEditor.this.innerEditors.length) {
                        IEditorPart iEditorPart = AbstractMultiEditor.this.innerEditors[n];
                        IWorkbenchPartReference iWorkbenchPartReference2 = ((PartSite)iEditorPart.getSite()).getPartReference();
                        partService.firePartOpened(iWorkbenchPartReference2);
                        ++n;
                    }
                }
            }

            @Override
            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            @Override
            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            @Override
            public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            }
        };
        this.getSite().getPage().addPartListener(this.propagationListener);
    }

    @Override
    public void dispose() {
        this.getSite().getPage().removePartListener(this.propagationListener);
        super.dispose();
    }

    public abstract Composite getInnerEditorContainer(IEditorReference var1);
}

