/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.operations.TimeTriggeredProgressMonitorDialog;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.MultiPageEditorSite;

public abstract class OperationHistoryActionHandler
extends Action
implements ActionFactory.IWorkbenchAction,
IAdaptable {
    private static final int MAX_LABEL_LENGTH = 32;
    private boolean pruning = false;
    private IPartListener partListener = new PartListener();
    private IOperationHistoryListener historyListener = new HistoryListener();
    private TimeTriggeredProgressMonitorDialog progressDialog;
    private IUndoContext undoContext = null;
    IWorkbenchPartSite site;

    OperationHistoryActionHandler(IWorkbenchPartSite iWorkbenchPartSite, IUndoContext iUndoContext) {
        super("");
        this.site = iWorkbenchPartSite;
        this.undoContext = iUndoContext;
        iWorkbenchPartSite.getPage().addPartListener(this.partListener);
        this.getHistory().addOperationHistoryListener(this.historyListener);
        this.update();
    }

    @Override
    public void dispose() {
        IOperationHistory iOperationHistory = this.getHistory();
        if (iOperationHistory != null) {
            iOperationHistory.removeOperationHistoryListener(this.historyListener);
        }
        if (this.isInvalid()) {
            return;
        }
        this.site.getPage().removePartListener(this.partListener);
        this.site = null;
        this.progressDialog = null;
        this.undoContext = null;
    }

    abstract void flush();

    abstract String getCommandString();

    abstract String getTooltipString();

    abstract String getSimpleCommandString();

    abstract String getSimpleTooltipString();

    IOperationHistory getHistory() {
        if (PlatformUI.getWorkbench() == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    abstract IUndoableOperation getOperation();

    /*
     * Loose catch block
     */
    public final void run() {
        block13: {
            if (this.isInvalid()) {
                return;
            }
            Shell shell = this.getWorkbenchWindow().getShell();
            this.progressDialog = new TimeTriggeredProgressMonitorDialog(shell, this.getWorkbenchWindow().getWorkbench().getProgressService().getLongOperationTime());
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    try {
                        OperationHistoryActionHandler.this.runCommand(iProgressMonitor);
                    }
                    catch (ExecutionException executionException) {
                        if (OperationHistoryActionHandler.this.pruning) {
                            OperationHistoryActionHandler.this.flush();
                        }
                        throw new InvocationTargetException(executionException);
                    }
                }
            };
            try {
                try {
                    boolean bl = false;
                    if (this.getOperation() instanceof IAdvancedUndoableOperation2) {
                        bl = ((IAdvancedUndoableOperation2)this.getOperation()).runInBackground();
                    }
                    this.progressDialog.run(bl, true, iRunnableWithProgress);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable == null) {
                        this.reportException(invocationTargetException);
                    } else {
                        this.reportException(throwable);
                    }
                    this.progressDialog = null;
                }
                catch (InterruptedException interruptedException) {
                    this.progressDialog = null;
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.progressDialog = null;
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.progressDialog = null;
            }
        }
    }

    abstract IStatus runCommand(IProgressMonitor var1) throws ExecutionException;

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IUndoContext.class)) {
            return this.undoContext;
        }
        if (clazz.equals(IProgressMonitor.class) && this.progressDialog != null) {
            return this.progressDialog.getProgressMonitor();
        }
        if (this.site != null) {
            if (clazz.equals(Shell.class)) {
                return this.getWorkbenchWindow().getShell();
            }
            if (clazz.equals(IWorkbenchWindow.class)) {
                return this.getWorkbenchWindow();
            }
            if (clazz.equals(IWorkbenchPart.class)) {
                return this.site.getPart();
            }
            IWorkbenchPart iWorkbenchPart = this.site.getPart();
            if (iWorkbenchPart != null) {
                return Util.getAdapter(iWorkbenchPart, clazz);
            }
        }
        return null;
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        if (this.site != null) {
            return this.site.getWorkbenchWindow();
        }
        return null;
    }

    abstract boolean shouldBeEnabled();

    public void setContext(IUndoContext iUndoContext) {
        if (iUndoContext == this.undoContext) {
            return;
        }
        this.undoContext = iUndoContext;
        this.update();
    }

    public void setPruneHistory(boolean bl) {
        this.pruning = bl;
    }

    public void update() {
        String string;
        String string2;
        if (this.isInvalid()) {
            return;
        }
        boolean bl = this.shouldBeEnabled();
        if (bl) {
            string2 = NLS.bind((String)this.getTooltipString(), (Object)this.getOperation().getLabel());
            string = NLS.bind((String)this.getCommandString(), (Object)this.shortenText(this.getOperation().getLabel()));
        } else {
            string2 = NLS.bind((String)WorkbenchMessages.Operations_undoRedoCommandDisabled, (Object)this.getSimpleTooltipString());
            string = this.getSimpleCommandString();
            if (this.undoContext != null && this.pruning) {
                this.flush();
            }
        }
        this.setText(string);
        this.setToolTipText(string2);
        this.setEnabled(bl);
    }

    private String shortenText(String string) {
        int n = string.length();
        if (n > 32) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 16;
            stringBuffer.append(string.substring(0, n2));
            stringBuffer.append("...");
            stringBuffer.append(string.substring(n - n2));
            return stringBuffer.toString();
        }
        return string;
    }

    final void reportException(Throwable throwable) {
        Throwable throwable2 = StatusUtil.getCause(throwable);
        Throwable throwable3 = throwable2 == null ? throwable : throwable2;
        String string = throwable3.getMessage();
        if (string == null) {
            string = WorkbenchMessages.WorkbenchWindow_exceptionMessage;
        }
        IStatus iStatus = StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, string, throwable3);
        WorkbenchPlugin.log(string, iStatus);
        StatusUtil.handleStatus(iStatus, 2, this.getWorkbenchWindow().getShell());
    }

    final boolean isInvalid() {
        return this.undoContext == null || this.site == null;
    }

    final IUndoContext getUndoContext() {
        return this.undoContext;
    }

    private class HistoryListener
    implements IOperationHistoryListener {
        private HistoryListener() {
        }

        public void historyNotification(final OperationHistoryEvent operationHistoryEvent) {
            IWorkbenchWindow iWorkbenchWindow = OperationHistoryActionHandler.this.getWorkbenchWindow();
            if (iWorkbenchWindow == null) {
                return;
            }
            Display display = iWorkbenchWindow.getWorkbench().getDisplay();
            if (display == null) {
                return;
            }
            switch (operationHistoryEvent.getEventType()) {
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    if (!operationHistoryEvent.getOperation().hasContext(OperationHistoryActionHandler.this.undoContext)) break;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            OperationHistoryActionHandler.this.update();
                        }
                    });
                    break;
                }
                case 7: {
                    if (!operationHistoryEvent.getOperation().hasContext(OperationHistoryActionHandler.this.undoContext)) break;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (OperationHistoryActionHandler.this.pruning) {
                                IStatus iStatus = operationHistoryEvent.getStatus();
                                if (iStatus == null || iStatus.getSeverity() != 8) {
                                    OperationHistoryActionHandler.this.flush();
                                }
                                OperationHistoryActionHandler.this.update();
                            } else {
                                OperationHistoryActionHandler.this.update();
                            }
                        }
                    });
                    break;
                }
                case 6: {
                    if (operationHistoryEvent.getOperation() != OperationHistoryActionHandler.this.getOperation()) break;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            OperationHistoryActionHandler.this.update();
                        }
                    });
                }
            }
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        @Override
        public void partActivated(IWorkbenchPart iWorkbenchPart) {
        }

        @Override
        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        @Override
        public void partClosed(IWorkbenchPart iWorkbenchPart) {
            if (OperationHistoryActionHandler.this.site != null && iWorkbenchPart.equals(OperationHistoryActionHandler.this.site.getPart())) {
                OperationHistoryActionHandler.this.dispose();
            } else if (OperationHistoryActionHandler.this.site instanceof MultiPageEditorSite && iWorkbenchPart.equals(((MultiPageEditorSite)OperationHistoryActionHandler.this.site).getMultiPageEditor())) {
                OperationHistoryActionHandler.this.dispose();
            }
        }

        @Override
        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        @Override
        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    }
}

