/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.operations;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.util.Util;

public final class NonLocalUndoUserApprover
implements IOperationApprover {
    private IUndoContext context;
    private IEditorPart part;
    private Object[] elements;
    private Class affectedObjectsClass;
    private ArrayList elementsAndAdapters;

    public NonLocalUndoUserApprover(IUndoContext iUndoContext, IEditorPart iEditorPart, Object[] objectArray, Class clazz) {
        this.context = iUndoContext;
        this.part = iEditorPart;
        this.affectedObjectsClass = clazz;
        this.elements = objectArray;
    }

    public IStatus proceedRedoing(IUndoableOperation iUndoableOperation, IOperationHistory iOperationHistory, IAdaptable iAdaptable) {
        if (!this.requiresApproval(iUndoableOperation, iAdaptable)) {
            return Status.OK_STATUS;
        }
        String string = NLS.bind((String)WorkbenchMessages.Operations_nonLocalRedoWarning, (Object)iUndoableOperation.getLabel(), (Object)this.part.getEditorInput().getName());
        return this.proceedWithOperation(iUndoableOperation, string, WorkbenchMessages.Operations_discardRedo, WorkbenchMessages.Workbench_redoToolTip);
    }

    public IStatus proceedUndoing(IUndoableOperation iUndoableOperation, IOperationHistory iOperationHistory, IAdaptable iAdaptable) {
        if (!this.requiresApproval(iUndoableOperation, iAdaptable)) {
            return Status.OK_STATUS;
        }
        String string = NLS.bind((String)WorkbenchMessages.Operations_nonLocalUndoWarning, (Object)iUndoableOperation.getLabel(), (Object)this.part.getEditorInput().getName());
        return this.proceedWithOperation(iUndoableOperation, string, WorkbenchMessages.Operations_discardUndo, WorkbenchMessages.Workbench_undoToolTip);
    }

    private IStatus proceedWithOperation(IUndoableOperation iUndoableOperation, final String string, final String string2, final String string3) {
        boolean bl;
        if (!(iUndoableOperation instanceof IAdvancedUndoableOperation)) {
            return Status.OK_STATUS;
        }
        Object[] objectArray = ((IAdvancedUndoableOperation)iUndoableOperation).getAffectedObjects();
        if (objectArray == null) {
            bl = false;
        } else {
            bl = true;
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (!this.elementsContains(object)) {
                    Object object2;
                    bl = false;
                    if (this.affectedObjectsClass != null && (object2 = Util.getAdapter(object, this.affectedObjectsClass)) != null && this.elementsContains(object2)) {
                        bl = true;
                    }
                    if (!bl) break;
                }
                ++n;
            }
        }
        if (bl) {
            return Status.OK_STATUS;
        }
        final int[] nArray = new int[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog messageDialog = new MessageDialog(NonLocalUndoUserApprover.this.part.getSite().getShell(), string3, null, string, 3, new String[]{IDialogConstants.OK_LABEL, string2, IDialogConstants.CANCEL_LABEL}, 0);
                nArray[0] = messageDialog.open();
            }
        });
        switch (nArray[0]) {
            case 0: {
                return Status.OK_STATUS;
            }
            case 1: {
                return IOperationHistory.OPERATION_INVALID_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }

    private boolean requiresApproval(IUndoableOperation iUndoableOperation, IAdaptable iAdaptable) {
        IUndoContext iUndoContext;
        if (!iUndoableOperation.hasContext(this.context)) {
            return false;
        }
        if (iUndoableOperation.getContexts().length == 1) {
            return false;
        }
        return iAdaptable == null || (iUndoContext = (IUndoContext)Util.getAdapter(iAdaptable, IUndoContext.class)) == null || iUndoContext.matches(this.context);
    }

    private boolean elementsContains(Object object) {
        int n;
        if (this.elements == null) {
            return false;
        }
        if (this.elementsAndAdapters == null) {
            this.elementsAndAdapters = new ArrayList(this.elements.length);
            n = 0;
            while (n < this.elements.length) {
                Object object2;
                Object object3 = this.elements[n];
                this.elementsAndAdapters.add(object3);
                if (this.affectedObjectsClass != null && !this.affectedObjectsClass.isInstance(object3) && (object2 = Util.getAdapter(object3, this.affectedObjectsClass)) != null) {
                    this.elementsAndAdapters.add(object2);
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.elementsAndAdapters.size()) {
            if (this.elementsAndAdapters.get(n).equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

