/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.LinearUndoViolationDetector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;

public final class LinearUndoViolationUserApprover
extends LinearUndoViolationDetector {
    private IWorkbenchPart part;
    private IUndoContext context;

    public LinearUndoViolationUserApprover(IUndoContext iUndoContext, IWorkbenchPart iWorkbenchPart) {
        this.part = iWorkbenchPart;
        this.context = iUndoContext;
    }

    protected IStatus allowLinearRedoViolation(IUndoableOperation iUndoableOperation, IUndoContext iUndoContext, IOperationHistory iOperationHistory, IAdaptable iAdaptable) {
        if (this.context != iUndoContext) {
            return Status.OK_STATUS;
        }
        final String string = NLS.bind((String)WorkbenchMessages.Operations_linearRedoViolation, (Object)this.getTitle(this.part), (Object)iUndoableOperation.getLabel());
        final boolean[] blArray = new boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LinearUndoViolationUserApprover.this.part.setFocus();
                blArray[0] = MessageDialog.openQuestion((Shell)LinearUndoViolationUserApprover.this.part.getSite().getShell(), (String)LinearUndoViolationUserApprover.this.getTitle(LinearUndoViolationUserApprover.this.part), (String)string);
            }
        });
        if (blArray[0]) {
            while (iUndoableOperation != iOperationHistory.getRedoOperation(iUndoContext)) {
                try {
                    IStatus iStatus = iOperationHistory.redo(iUndoContext, null, iAdaptable);
                    if (iStatus.isOK()) continue;
                    iOperationHistory.dispose(iUndoContext, false, true, false);
                    return Status.CANCEL_STATUS;
                }
                catch (ExecutionException executionException) {
                    iOperationHistory.dispose(iUndoContext, false, true, false);
                    return Status.CANCEL_STATUS;
                }
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    protected IStatus allowLinearUndoViolation(IUndoableOperation iUndoableOperation, IUndoContext iUndoContext, IOperationHistory iOperationHistory, IAdaptable iAdaptable) {
        if (this.context != iUndoContext) {
            return Status.OK_STATUS;
        }
        final String string = NLS.bind((String)WorkbenchMessages.Operations_linearUndoViolation, (Object)this.getTitle(this.part), (Object)iUndoableOperation.getLabel());
        final boolean[] blArray = new boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LinearUndoViolationUserApprover.this.part.setFocus();
                blArray[0] = MessageDialog.openQuestion((Shell)LinearUndoViolationUserApprover.this.part.getSite().getShell(), (String)LinearUndoViolationUserApprover.this.getTitle(LinearUndoViolationUserApprover.this.part), (String)string);
            }
        });
        if (blArray[0]) {
            while (iUndoableOperation != iOperationHistory.getUndoOperation(iUndoContext)) {
                try {
                    IStatus iStatus = iOperationHistory.undo(iUndoContext, null, iAdaptable);
                    if (iStatus.isOK()) continue;
                    iOperationHistory.dispose(iUndoContext, true, false, false);
                    return Status.CANCEL_STATUS;
                }
                catch (ExecutionException executionException) {
                    iOperationHistory.dispose(iUndoContext, true, false, false);
                    return Status.CANCEL_STATUS;
                }
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private String getTitle(IWorkbenchPart iWorkbenchPart) {
        String string = iWorkbenchPart instanceof IWorkbenchPart2 ? ((IWorkbenchPart2)iWorkbenchPart).getPartName() : iWorkbenchPart.getTitle();
        if (string == null) {
            string = "";
        }
        return string;
    }
}

